/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation.rpc;

import com.alibaba.dashscope.common.ErrorType;
import com.alibaba.dashscope.common.Protocol;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.conversation.ConversationMessageStatus;
import com.alibaba.dashscope.conversation.ConversationParam;
import com.alibaba.dashscope.conversation.ConversationResult;
import com.alibaba.dashscope.conversation.EventType;
import com.alibaba.dashscope.conversation.rpc.ConversationRpc;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.protocol.HttpFactory;
import com.alibaba.dashscope.utils.Constants;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConversationHttpRpc
implements ConversationRpc {
    private static final Logger log = LoggerFactory.getLogger(ConversationHttpRpc.class);

    @Override
    public void call(ConversationParam param, ResultCallback<ConversationResult> callback) {
        String url = Constants.baseHttpApiUrl;
        if (param.getApiKey() == null && Constants.apiKey == null) {
            callback.onError(new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().statusCode(401)).code(ErrorType.API_KEY_ERROR.getValue())).message(ErrorType.API_KEY_ERROR.getValue())).build()));
            return;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        url = url + param.url();
        HttpPost request = new HttpPost(url);
        request.addHeader("Authorization", "Bearer " + (param.getApiKey() == null ? Constants.apiKey : param.getApiKey()));
        request.addHeader("Content-Type", "application/json");
        if (param.isStream()) {
            request.addHeader("Accept", "text/event-stream");
            request.addHeader("X-Accel-Buffering", "no");
            request.addHeader("X-DashScope-SSE", "enable");
        } else {
            request.addHeader("Accept", "application/json");
        }
        if (param.isSecurityCheck()) {
            request.addHeader("X-DashScope-DataInspection", "enable");
        }
        try {
            StringEntity entity = new StringEntity(param.buildMessageBody(Protocol.HTTP.getValue()), "UTF-8");
            request.setEntity((HttpEntity)entity);
        }
        catch (ApiException e) {
            callback.onError(e);
            return;
        }
        this.send((HttpRequestBase)request, callback, param.isStream(), param.resultType(), param.getMsgId());
    }

    private void send(HttpRequestBase queryMethod, final ResultCallback<ConversationResult> callback, final boolean stream, final Class<? extends ConversationResult> resultType, final String msgId) {
        try {
            HttpFactory.getInstance().getHttpClient().execute((HttpUriRequest)queryMethod, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    block63: {
                        try {
                            int statusCode = response.getStatusLine().getStatusCode();
                            HttpEntity entity = response.getEntity();
                            if (statusCode == 200) {
                                if (entity == null) break block63;
                                ConversationResult result = null;
                                try (InputStream inputStream = entity.getContent();
                                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                                    if (stream) {
                                        String line;
                                        boolean lastIsError = false;
                                        while ((line = reader.readLine()) != null) {
                                            if (line.startsWith("event:error") || line.startsWith("event: error")) {
                                                lastIsError = true;
                                                continue;
                                            }
                                            if (!line.startsWith("data:")) continue;
                                            line = line.substring(5).trim();
                                            if (lastIsError) {
                                                ConversationMessageStatus status = ConversationHttpRpc.this.parseMessageStatus(line, 500, response);
                                                callback.onError(new ApiException(status));
                                                continue;
                                            }
                                            result = (ConversationResult)resultType.newInstance();
                                            result.loadFromMessage(Protocol.HTTP.getValue(), line);
                                            result.setEventType(EventType.RESULT_GENERATED.getValue());
                                            callback.onEvent(EventType.RESULT_GENERATED.getValue(), result);
                                        }
                                        if (!lastIsError) {
                                            if (result != null) {
                                                String tmp = JsonUtils.toJson(result);
                                                result = (ConversationResult)JsonUtils.fromJson(tmp, resultType);
                                                result.setEventType(EventType.TASK_FINISHED.getValue());
                                            }
                                            callback.onEvent(EventType.TASK_FINISHED.getValue(), result);
                                        }
                                    } else {
                                        String line;
                                        StringBuilder content = new StringBuilder();
                                        while ((line = reader.readLine()) != null) {
                                            content.append(line);
                                            content.append(System.lineSeparator());
                                        }
                                        result = (ConversationResult)resultType.newInstance();
                                        result.loadFromMessage(Protocol.HTTP.getValue(), content.toString());
                                        result.setEventType(EventType.TASK_FINISHED.getValue());
                                        callback.onEvent(EventType.TASK_FINISHED.getValue(), result);
                                    }
                                    break block63;
                                }
                            }
                            StringBuilder content = null;
                            if (entity != null) {
                                try (InputStream inputStream = entity.getContent();
                                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                                    String line;
                                    content = new StringBuilder();
                                    while ((line = reader.readLine()) != null) {
                                        content.append(line);
                                        content.append(System.lineSeparator());
                                    }
                                }
                                catch (Exception e) {
                                    log.error("Error occurs when reading error information from server.", (Throwable)e);
                                }
                            }
                            ConversationMessageStatus status = ConversationHttpRpc.this.parseMessageStatus(content != null ? content.toString() : null, statusCode, response);
                            callback.onError(new ApiException(status));
                        }
                        catch (Exception e) {
                            callback.onError(new ApiException(e));
                        }
                    }
                }

                public void failed(Exception ex) {
                    callback.onError(new ApiException(ex));
                }

                public void cancelled() {
                    Status status = ((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().code(ErrorType.REQUEST_CANCELLED.getValue())).msgId(msgId)).statusCode(500)).build();
                    callback.onError(new ApiException(status));
                }
            });
        }
        catch (Exception e) {
            callback.onError(new ApiException(e));
        }
    }

    private ConversationMessageStatus parseMessageStatus(String payload, int statusCode, HttpResponse response) {
        if (payload == null) {
            return ((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().statusCode(statusCode)).code(ErrorType.RESPONSE_ERROR.getValue())).message(ErrorType.RESPONSE_ERROR.getValue())).build();
        }
        boolean isJson = false;
        Header header = response.getFirstHeader("Content-Type");
        if (header != null && header.getValue() != null && (header.getValue().toLowerCase().contains("application/json") || header.getValue().toLowerCase().contains("text/event-stream"))) {
            isJson = true;
        }
        if (isJson) {
            JsonObject json = JsonUtils.parse(payload);
            return ((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)ConversationMessageStatus.builder().code(json.get("code") == null ? null : json.get("code").getAsString())).statusCode(statusCode)).message(json.get("message") == null ? null : json.get("message").getAsString())).usage(json.getAsJsonObject("usage"))).msgId(json.get("request_id") == null ? null : json.get("request_id").getAsString())).build();
        }
        return ((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().statusCode(statusCode)).code(ErrorType.RESPONSE_ERROR.getValue())).message(payload)).build();
    }
}

