/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation.rpc;

import com.alibaba.dashscope.common.ErrorType;
import com.alibaba.dashscope.common.Protocol;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.conversation.ConversationMessageStatus;
import com.alibaba.dashscope.conversation.ConversationParam;
import com.alibaba.dashscope.conversation.ConversationResult;
import com.alibaba.dashscope.conversation.EventType;
import com.alibaba.dashscope.conversation.WebsocketConnectionStatus;
import com.alibaba.dashscope.conversation.rpc.ConversationRpc;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.utils.Constants;
import java.net.URI;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.enums.ReadyState;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConversationWebsocketRpc
implements ConversationRpc {
    private static final Logger log = LoggerFactory.getLogger(ConversationWebsocketRpc.class);
    private final WebSocketClient client;
    private Class<? extends ConversationResult> resultType;
    private ResultCallback<ConversationResult> resultCallback = null;

    public ConversationWebsocketRpc() {
        try {
            this.client = new WebSocketClient(new URI(Constants.baseWebsocketApiUrl)){

                public void onOpen(ServerHandshake handShakeData) {
                    assert (ConversationWebsocketRpc.this.resultCallback != null);
                    ConversationWebsocketRpc.this.resultCallback.onOpen(((WebsocketConnectionStatus.WebsocketConnectionStatusBuilder)((WebsocketConnectionStatus.WebsocketConnectionStatusBuilder)WebsocketConnectionStatus.builder().statusCode(handShakeData.getHttpStatus())).message(handShakeData.getHttpStatusMessage())).build());
                }

                public void onMessage(String message) {
                    try {
                        assert (ConversationWebsocketRpc.this.resultCallback != null && ConversationWebsocketRpc.this.resultType != null);
                        ConversationResult result = (ConversationResult)ConversationWebsocketRpc.this.resultType.newInstance();
                        result.loadFromMessage(Protocol.WEBSOCKET.getValue(), message);
                        String eventType = result.getEventType();
                        if (EventType.RESULT_GENERATED.getValue().equals(eventType) || EventType.TASK_FINISHED.getValue().equals(eventType)) {
                            ConversationWebsocketRpc.this.resultCallback.onEvent(eventType, result);
                        }
                    }
                    catch (Exception e) {
                        ConversationWebsocketRpc.this.resultCallback.onError(e instanceof ApiException ? e : new ApiException(e));
                    }
                }

                public void onClose(int code, String reason, boolean remote) {
                    assert (ConversationWebsocketRpc.this.resultCallback != null);
                    if ((reason == null ? "" : reason).contains("Unauthorized")) {
                        ConversationWebsocketRpc.this.resultCallback.onError(new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().statusCode(401)).code(String.valueOf(code))).message(reason)).build()));
                    } else {
                        ConversationWebsocketRpc.this.resultCallback.onClose(((WebsocketConnectionStatus.WebsocketConnectionStatusBuilder)((WebsocketConnectionStatus.WebsocketConnectionStatusBuilder)((WebsocketConnectionStatus.WebsocketConnectionStatusBuilder)WebsocketConnectionStatus.builder().statusCode(code)).message(reason)).remote(remote)).build());
                    }
                }

                public void onError(Exception ex) {
                    assert (ConversationWebsocketRpc.this.resultCallback != null);
                    ConversationWebsocketRpc.this.resultCallback.onError(new ApiException(ex));
                }

                public void close(int code) {
                    assert (ConversationWebsocketRpc.this.resultCallback != null);
                    ConversationWebsocketRpc.this.resultCallback.doClose(((WebsocketConnectionStatus.WebsocketConnectionStatusBuilder)WebsocketConnectionStatus.builder().statusCode(code)).build());
                    super.close(code);
                }
            };
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    protected void finalize() throws Throwable {
        this.client.closeBlocking();
        super.finalize();
    }

    @Override
    public void call(ConversationParam param, ResultCallback<ConversationResult> callback) {
        try {
            this.resultCallback = callback;
            this.resultType = param.resultType();
            boolean connected = true;
            if (this.client.getReadyState() == ReadyState.NOT_YET_CONNECTED) {
                if (param.getApiKey() == null && Constants.apiKey == null) {
                    callback.onError(new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().statusCode(401)).code(ErrorType.API_KEY_ERROR.getValue())).message(ErrorType.API_KEY_ERROR.getValue())).build()));
                    return;
                }
                this.client.addHeader("Authorization", param.getApiKey() == null ? Constants.apiKey : param.getApiKey());
                if (param.isSecurityCheck()) {
                    this.client.addHeader("X-DashScope-DataInspection", "enable");
                }
                connected = this.client.connectBlocking();
            } else if (this.client.getReadyState() == ReadyState.CLOSED) {
                if (param.getApiKey() == null && Constants.apiKey == null) {
                    callback.onError(new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().statusCode(401)).code(ErrorType.API_KEY_ERROR.getValue())).message(ErrorType.API_KEY_ERROR.getValue())).build()));
                    return;
                }
                this.client.addHeader("Authorization", param.getApiKey() == null ? Constants.apiKey : param.getApiKey());
                if (param.isSecurityCheck()) {
                    this.client.addHeader("X-DashScope-DataInspection", "enable");
                }
                connected = this.client.reconnectBlocking();
            }
            if (!connected) {
                return;
            }
            this.client.send(param.buildMessageBody(Protocol.WEBSOCKET.getValue()));
        }
        catch (Exception e) {
            this.resultCallback.onError(e instanceof ApiException ? e : new ApiException(e));
        }
    }
}

