/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.utils.Constants;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class HttpFactory {
    private static volatile HttpFactory instance;
    private final PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor());
    private final CloseableHttpAsyncClient httpClient;
    private final ScheduledExecutorService executorService;

    private HttpFactory() throws IOReactorException {
        this.connectionManager.setMaxTotal(Constants.max_connections_http);
        this.connectionManager.setDefaultMaxPerRoute(Constants.max_connections_per_route_http);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Constants.CONNECT_TIMEOUT).setConnectionRequestTimeout(Constants.CONNECTION_REQUEST_TIMEOUT).setSocketTimeout(Constants.SOCKET_TIMEOUT).build();
        this.httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(requestConfig).build();
        this.httpClient.start();
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("http-schedule-pool-%d").daemon(true).build());
        this.executorService.scheduleAtFixedRate(() -> {
            try {
                this.connectionManager.closeExpiredConnections();
                this.connectionManager.closeIdleConnections(10L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpFactory getInstance() throws IOReactorException {
        if (instance != null) return instance;
        Class<HttpFactory> clazz = HttpFactory.class;
        synchronized (HttpFactory.class) {
            if (instance != null) return instance;
            instance = new HttpFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public CloseableHttpAsyncClient getHttpClient() {
        return this.httpClient;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }
}

