/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistry<T> {
    private static final Logger log = LoggerFactory.getLogger(TypeRegistry.class);
    private final Map<String, Class<? extends T>> registry = new HashMap<String, Class<? extends T>>();

    public synchronized void register(String type, Class<? extends T> clazz) {
        if (!this.registry.containsKey(type)) {
            this.registry.put(type, clazz);
        }
    }

    public synchronized Class<? extends T> get(String type) {
        Class<? extends T> t = this.registry.get(type);
        if (t == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("There is no class definition corresponding to the ").append(type).append(";");
            builder.append("ensure that the corresponding class is registered before the list.");
            builder.append("You can register with ToolBase.registerTool(toolType, TheTool.class)");
            log.warn(builder.toString());
            return null;
        }
        return t;
    }
}

