/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2OutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.phoenix.visitor.PhoenixOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.ArrayList;
import java.util.List;

public class ParameterizedOutputVisitorUtils {
    public static final String ATTR_PARAMS_SKIP = "druid.parameterized.skip";
    public static final String ATTR_MERGED = "parameterized.mergedList";

    public static String parameterize(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        List<SQLStatement> statementList = parser.parseStatementList();
        if (statementList.size() == 0) {
            return sql;
        }
        StringBuilder out = new StringBuilder(sql.length());
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        for (int i = 0; i < statementList.size(); ++i) {
            SQLStatement stmt;
            if (i > 0) {
                out.append(";\n");
            }
            if ((stmt = statementList.get(i)).hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            stmt.accept(visitor);
        }
        if (visitor.getReplaceCount() == 0 && parser.getLexer().getCommentCount() == 0) {
            return sql;
        }
        return out.toString();
    }

    public static String parameterize(List<SQLStatement> statementList, String dbType) {
        StringBuilder out = new StringBuilder();
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        for (int i = 0; i < statementList.size(); ++i) {
            SQLStatement stmt;
            if (i > 0) {
                out.append(";\n");
            }
            if ((stmt = statementList.get(i)).hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            stmt.accept(visitor);
        }
        return out.toString();
    }

    public static ParameterizedVisitor createParameterizedOutputVisitor(Appendable out, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleParameterizedOutputVisitor(out);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlOutputVisitor(out, true);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGOutputVisitor(out, true);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerOutputVisitor(out, true);
        }
        if ("db2".equals(dbType)) {
            return new DB2OutputVisitor(out, true);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixOutputVisitor(out, true);
        }
        return new SQLASTOutputVisitor(out, true);
    }

    public static boolean checkParameterize(SQLObject x) {
        if (Boolean.TRUE.equals(x.getAttribute(ATTR_PARAMS_SKIP))) {
            return false;
        }
        SQLObject parent = x.getParent();
        return !(parent instanceof SQLDataType) && !(parent instanceof SQLColumnDefinition) && !(parent instanceof SQLServerTop) && !(parent instanceof SQLSelectOrderByItem);
    }

    public static boolean visit(ParameterizedVisitor v, SQLVariantRefExpr x) {
        v.print('?');
        v.incrementReplaceCunt();
        if (v instanceof ExportParameterVisitor) {
            ExportParameterVisitorUtils.exportParameter(((ExportParameterVisitor)((Object)v)).getParameters(), x);
        }
        return false;
    }

    static void putMergedArribute(SQLObject object, SQLObject item) {
        ArrayList<SQLObject> mergedList = (ArrayList<SQLObject>)object.getAttribute(ATTR_MERGED);
        if (mergedList == null) {
            mergedList = new ArrayList<SQLObject>();
            object.putAttribute(ATTR_MERGED, mergedList);
        }
        mergedList.add(item);
    }

    public static SQLBinaryOpExpr merge(ParameterizedVisitor v, SQLBinaryOpExpr x) {
        SQLBinaryOpExpr mergedLeft;
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        SQLObject parent = x.getParent();
        if (left instanceof SQLLiteralExpr && right instanceof SQLLiteralExpr) {
            SQLBinaryOperator op = x.getOperator();
            if (op == SQLBinaryOperator.Equality || op == SQLBinaryOperator.NotEqual || op == SQLBinaryOperator.LessThanOrGreater) {
                if (left instanceof SQLIntegerExpr && right instanceof SQLIntegerExpr) {
                    if (((SQLIntegerExpr)left).getNumber().intValue() < 100) {
                        left.putAttribute(ATTR_PARAMS_SKIP, true);
                    }
                    if (((SQLIntegerExpr)right).getNumber().intValue() < 100) {
                        right.putAttribute(ATTR_PARAMS_SKIP, true);
                    }
                } else {
                    left.putAttribute(ATTR_PARAMS_SKIP, true);
                    right.putAttribute(ATTR_PARAMS_SKIP, true);
                }
            }
            return x;
        }
        while (x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr leftBinaryExpr;
            if (x.getLeft() instanceof SQLBinaryOpExpr && (leftBinaryExpr = (SQLBinaryOpExpr)x.getLeft()).getRight().equals(x.getRight())) {
                x = leftBinaryExpr;
                v.incrementReplaceCunt();
                continue;
            }
            SQLBinaryOpExpr mergedRight = ParameterizedOutputVisitorUtils.merge(v, (SQLBinaryOpExpr)x.getRight());
            if (mergedRight != x.getRight()) {
                x = new SQLBinaryOpExpr(x.getLeft(), x.getOperator(), mergedRight);
                v.incrementReplaceCunt();
            }
            x.setParent(parent);
            break;
        }
        if (x.getLeft() instanceof SQLBinaryOpExpr && (mergedLeft = ParameterizedOutputVisitorUtils.merge(v, (SQLBinaryOpExpr)x.getLeft())) != x.getLeft()) {
            SQLBinaryOpExpr tmp = new SQLBinaryOpExpr((SQLExpr)mergedLeft, x.getOperator(), x.getRight());
            tmp.setParent(parent);
            x = tmp;
            v.incrementReplaceCunt();
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanOr && x.getLeft() instanceof SQLBinaryOpExpr && x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr rightBinary;
            SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)x.getLeft();
            if (ParameterizedOutputVisitorUtils.mergeEqual(leftBinary, rightBinary = (SQLBinaryOpExpr)x.getRight())) {
                v.incrementReplaceCunt();
                leftBinary.setParent(x.getParent());
                ParameterizedOutputVisitorUtils.putMergedArribute(leftBinary, rightBinary);
                return leftBinary;
            }
            if (ParameterizedOutputVisitorUtils.isLiteralExpr(leftBinary.getLeft()) && leftBinary.getOperator() == SQLBinaryOperator.BooleanOr && ParameterizedOutputVisitorUtils.mergeEqual(leftBinary.getRight(), x.getRight())) {
                v.incrementReplaceCunt();
                ParameterizedOutputVisitorUtils.putMergedArribute(leftBinary, rightBinary);
                return leftBinary;
            }
        }
        return x;
    }

    private static boolean mergeEqual(SQLExpr a, SQLExpr b) {
        if (!(a instanceof SQLBinaryOpExpr)) {
            return false;
        }
        if (!(b instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryA = (SQLBinaryOpExpr)a;
        SQLBinaryOpExpr binaryB = (SQLBinaryOpExpr)b;
        if (binaryA.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (binaryB.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (!(binaryA.getRight() instanceof SQLLiteralExpr) && !(binaryA.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        if (!(binaryB.getRight() instanceof SQLLiteralExpr) && !(binaryB.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        return binaryA.getLeft().toString().equals(binaryB.getLeft().toString());
    }

    private static boolean isLiteralExpr(SQLExpr expr) {
        if (expr instanceof SQLLiteralExpr) {
            return true;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binary = (SQLBinaryOpExpr)expr;
            return ParameterizedOutputVisitorUtils.isLiteralExpr(binary.getLeft()) && ParameterizedOutputVisitorUtils.isLiteralExpr(binary.getRight());
        }
        return false;
    }
}

