/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidStatementConnection;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.proxy.jdbc.ConnectionProxyImpl;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class ValidConnectionCheckerAdapter
implements ValidConnectionChecker {
    @Override
    public boolean isValidConnection(Connection conn, String query, int validationQueryTimeout) throws Exception {
        if (StringUtils.isEmpty(query)) {
            return true;
        }
        return ValidConnectionCheckerAdapter.execValidQuery(conn, query, validationQueryTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execValidQuery(Connection conn, String query, int validationQueryTimeout) throws Exception {
        boolean bl;
        boolean isDruidStatementConnection;
        if (conn instanceof DruidPooledConnection) {
            conn = ((DruidPooledConnection)conn).getConnection();
        }
        Connection rawConn = conn instanceof ConnectionProxyImpl ? ((ConnectionProxyImpl)conn).getConnectionRaw() : conn;
        Statement stmt = null;
        if (rawConn instanceof DruidStatementConnection) {
            stmt = ((DruidStatementConnection)rawConn).getStatement();
            isDruidStatementConnection = true;
        } else {
            isDruidStatementConnection = false;
        }
        ResultSet rs = null;
        try {
            if (!isDruidStatementConnection) {
                stmt = rawConn.createStatement();
            }
            if (validationQueryTimeout > 0) {
                stmt.setQueryTimeout(validationQueryTimeout);
            }
            rs = stmt.executeQuery(query);
            bl = rs.next();
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            if (!isDruidStatementConnection) {
                JdbcUtils.close(stmt);
            }
            throw throwable;
        }
        JdbcUtils.close(rs);
        if (!isDruidStatementConnection) {
            JdbcUtils.close(stmt);
        }
        return bl;
    }

    @Override
    public void configFromProperties(Properties properties) {
    }
}

