/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.parser;

import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeclareStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryAssertStatement;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQueryCreateTableParser;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQueryExprParser;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQuerySelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class BigQueryStatementParser
extends SQLStatementParser {
    public BigQueryStatementParser(String sql) {
        super(new BigQueryExprParser(sql));
    }

    public BigQueryStatementParser(String sql, SQLParserFeature ... features) {
        super(new BigQueryExprParser(sql, features));
    }

    public BigQueryStatementParser(Lexer lexer) {
        super(new BigQueryExprParser(lexer));
    }

    @Override
    public BigQuerySelectParser createSQLSelectParser() {
        return new BigQuerySelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new BigQueryCreateTableParser(this.exprParser);
    }

    @Override
    public SQLCreateFunctionStatement parseCreateFunction() {
        SQLCreateFunctionStatement createFunction = new SQLCreateFunctionStatement();
        this.accept(Token.CREATE);
        if (this.lexer.nextIfIdentifier("TEMP") || this.lexer.nextIfIdentifier(FnvHash.Constants.TEMPORARY)) {
            createFunction.setTemporary(true);
        }
        this.accept(Token.FUNCTION);
        createFunction.setName(this.exprParser.name());
        this.parameters(createFunction.getParameters(), createFunction);
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.RETURNS)) {
            createFunction.setReturnDataType(this.exprParser.parseDataType());
        }
        while (true) {
            if (this.lexer.nextIfIdentifier("LANGUAGE")) {
                createFunction.setLanguage(this.lexer.stringVal());
                this.accept(Token.IDENTIFIER);
                continue;
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
                this.exprParser.parseAssignItem(createFunction.getOptions(), (SQLObject)createFunction);
                continue;
            }
            if (!this.lexer.nextIf(Token.AS)) break;
            if (this.lexer.nextIf(Token.LPAREN)) {
                createFunction.setBlock(new SQLExprStatement(this.exprParser.expr()));
                this.accept(Token.RPAREN);
                continue;
            }
            this.lexer.nextIfIdentifier("R");
            createFunction.setWrappedSource(this.lexer.stringVal());
            this.accept(Token.LITERAL_TEXT_BLOCK);
        }
        if (this.lexer.nextIf(Token.SEMI)) {
            createFunction.setAfterSemi(true);
        }
        return createFunction;
    }

    @Override
    public SQLStatement parseDeclare() {
        SQLDeclareItem item;
        this.accept(Token.DECLARE);
        SQLDeclareStatement declareStatement = new SQLDeclareStatement();
        while (true) {
            item = new SQLDeclareItem();
            item.setName(this.exprParser.name());
            declareStatement.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() != Token.EOF) {
            item.setDataType(this.exprParser.parseDataType());
            if (this.lexer.nextIf(Token.DEFAULT)) {
                item.setValue(this.exprParser.expr());
            }
        } else {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        return declareStatement;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.identifierEquals("ASSERT")) {
            statementList.add(this.parseAssert());
            return true;
        }
        if (this.lexer.token() == Token.BEGIN) {
            statementList.add(this.parseBlock());
            return true;
        }
        return false;
    }

    protected SQLStatement parseAssert() {
        this.acceptIdentifier("ASSERT");
        BigQueryAssertStatement stmt = new BigQueryAssertStatement();
        stmt.setExpr(this.exprParser.expr());
        if (this.lexer.nextIf(Token.AS)) {
            stmt.setAs((SQLCharExpr)this.exprParser.primary());
        }
        return stmt;
    }

    @Override
    public SQLDeleteStatement parseDeleteStatement() {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement(this.getDbType());
        this.accept(Token.DELETE);
        this.lexer.nextIf(Token.FROM);
        SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
        deleteStatement.setTableSource(tableSource);
        if (this.lexer.nextIf(Token.WHERE)) {
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    @Override
    protected void mergeBeforeName() {
        this.lexer.nextIf(Token.INTO);
    }

    @Override
    public SQLStatement parseBlock() {
        this.accept(Token.BEGIN);
        SQLBlockStatement block = new SQLBlockStatement();
        this.parseStatementList(block.getStatementList());
        this.accept(Token.END);
        return block;
    }

    @Override
    protected void parseInsert0(SQLInsertInto insertStatement, boolean acceptSubQuery) {
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                insertStatement.setAlias(this.tableAlias());
            }
            this.parseInsert0Hints(insertStatement, false);
            if (this.lexer.token() == Token.IDENTIFIER) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        super.parseInsert0(insertStatement, acceptSubQuery);
    }

    @Override
    protected void createViewAs(SQLCreateViewStatement createView) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
            this.exprParser.parseAssignItem(createView.getOptions(), (SQLObject)createView);
        }
        super.createViewAs(createView);
    }
}

