/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKCreateTableStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class CKCreateTableParser
extends SQLCreateTableParser {
    public CKCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new CKCreateTableStatement();
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        this.lexer.nextToken();
        this.accept(Token.BY);
        SQLPartitionByList sqlPartitionBy = new SQLPartitionByList();
        sqlPartitionBy.setType(SQLPartitionByList.PartitionByListType.LIST_EXPRESSION);
        boolean hasParen = false;
        if (this.lexer.nextIf(Token.LPAREN)) {
            hasParen = true;
        }
        while (true) {
            sqlPartitionBy.addColumn(this.exprParser.expr());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (hasParen) {
            this.accept(Token.RPAREN);
        }
        return sqlPartitionBy;
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        SQLExpr expr;
        CKCreateTableStatement ckStmt = (CKCreateTableStatement)stmt;
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            ckStmt.setEngine(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.PARTITION) {
            ckStmt.setPartitionBy(this.parsePartitionBy());
        }
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            ckStmt.setOrderBy(orderBy);
        }
        if (this.lexer.token() == Token.PRIMARY) {
            SQLPrimaryKey sqlPrimaryKey = this.exprParser.parsePrimaryKey();
            ckStmt.setPrimaryKey(sqlPrimaryKey);
        }
        if (this.lexer.identifierEquals("SAMPLE")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            expr = this.exprParser.expr();
            ckStmt.setSampleBy(expr);
        }
        if (this.lexer.token() == Token.TTL) {
            this.lexer.nextToken();
            expr = this.exprParser.expr();
            ckStmt.setTtl(expr);
        }
        if (this.lexer.token() == Token.SETTINGS) {
            this.lexer.nextToken();
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                item.setParent(ckStmt);
                ckStmt.getSettings().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
    }

    @Override
    protected void createTableAfterName(SQLCreateTableStatement createTable) {
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("CLUSTER");
            if (this.lexer.token() == Token.IDENTIFIER) {
                String clusterName = this.lexer.stringVal();
                CKCreateTableStatement ckStmt = (CKCreateTableStatement)createTable;
                ckStmt.setOnClusterName(clusterName);
                this.lexer.nextToken();
            } else {
                this.setErrorEndPos(this.lexer.pos());
                throw new ParserException("syntax error, expect IDENTIFIER, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
            }
        }
    }
}

