/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.impala.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class ImpalaInsertStatement
extends HiveInsertStatement {
    private List<SQLHint> insertHints = new ArrayList<SQLHint>();
    private List<SQLHint> selectHints = new ArrayList<SQLHint>();

    public ImpalaInsertStatement() {
        this.dbType = DbType.impala;
    }

    public void cloneTo(ImpalaInsertStatement x) {
        SQLHint h2;
        super.cloneTo(x);
        for (SQLHint hint : this.insertHints) {
            h2 = hint.clone();
            h2.setParent(x);
            x.insertHints.add(h2);
        }
        for (SQLHint hint : this.selectHints) {
            h2 = hint.clone();
            h2.setParent(x);
            x.selectHints.add(h2);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.with);
            this.acceptChild(visitor, this.insertHints);
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.partitions);
            this.acceptChild(visitor, this.valuesList);
            this.acceptChild(visitor, this.selectHints);
            this.acceptChild(visitor, this.query);
        }
        visitor.endVisit(this);
    }

    public List<SQLHint> getInsertHints() {
        return this.insertHints;
    }

    public void setInsertHints(List<SQLHint> insertHints) {
        this.insertHints = insertHints;
    }

    public List<SQLHint> getSelectHints() {
        return this.selectHints;
    }

    public void setSelectHints(List<SQLHint> selectHint) {
        this.selectHints = selectHint;
    }
}

