/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.impala.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionSingle;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveOutputVisitor;
import com.alibaba.druid.sql.dialect.impala.ast.ImpalaSQLPartitionValue;
import com.alibaba.druid.sql.dialect.impala.stmt.ImpalaCreateTableStatement;
import com.alibaba.druid.sql.dialect.impala.stmt.ImpalaInsertStatement;
import com.alibaba.druid.sql.dialect.impala.visitor.ImpalaASTVisitor;
import java.util.List;

public class ImpalaOutputVisitor
extends HiveOutputVisitor
implements ImpalaASTVisitor {
    public ImpalaOutputVisitor(StringBuilder appender) {
        super(appender);
        this.dbType = DbType.impala;
    }

    public ImpalaOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.impala;
    }

    @Override
    protected void printJoinHint(SQLJoinTableSource x) {
        if (!x.getHints().isEmpty()) {
            this.print(' ');
            this.printHints(x.getHints());
        }
    }

    @Override
    protected void printCached(SQLCreateTableStatement x) {
        if (x instanceof ImpalaCreateTableStatement) {
            ImpalaCreateTableStatement createTable = (ImpalaCreateTableStatement)x;
            if (createTable.isCached()) {
                this.println();
                this.print0(this.ucase ? "CACHED IN " : "cached in ");
                createTable.getCachedPool().accept(this);
                if (createTable.getCachedReplication() != -1) {
                    this.print0(" WITH REPLICATION = ");
                    this.print0(String.valueOf(createTable.getCachedReplication()));
                }
            }
            if (createTable.isUnCached()) {
                this.println();
                this.print0(this.ucase ? "UNCACHED" : "uncached");
            }
        }
    }

    @Override
    public boolean visit(ImpalaCreateTableStatement x) {
        this.printCreateTable(x, true, false);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        if (x instanceof ImpalaCreateTableStatement) {
            return this.visit((ImpalaCreateTableStatement)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (x instanceof ImpalaInsertStatement) {
            return this.visit((ImpalaInsertStatement)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(ImpalaInsertStatement x) {
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        if (x.isUpsert()) {
            this.print0(this.ucase ? "UPSERT " : "upsert ");
            this.printHint(x, true);
            this.print0(this.ucase ? "INTO " : "into ");
        } else {
            this.print0(this.ucase ? "INSERT " : "insert ");
            this.printHint(x, true);
            if (x.isOverwrite()) {
                this.print0(this.ucase ? "OVERWRITE " : "overwrite ");
            } else {
                this.print0(this.ucase ? "INTO " : "into ");
            }
        }
        x.getTableSource().accept(this);
        String columnsString = x.getColumnsString();
        if (columnsString != null) {
            this.print0(columnsString);
        } else {
            this.printInsertColumns(x.getColumns());
        }
        if (!x.getValuesList().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(x.getValuesList(), ", ");
        } else if (x.getQuery() != null) {
            this.println();
            this.printHint(x, false);
            x.getQuery().accept(this);
        }
        return false;
    }

    private void printHint(ImpalaInsertStatement x, boolean isInsert) {
        List<SQLHint> hints;
        List<SQLHint> list = hints = isInsert ? x.getInsertHints() : x.getSelectHints();
        if (!hints.isEmpty()) {
            this.printHints(hints);
            this.print(' ');
        }
    }

    private void printHints(List<SQLHint> hints) {
        for (SQLHint hint : hints) {
            if (hint instanceof SQLCommentHint) {
                this.print0(hint.toString());
                continue;
            }
            if (!(hint instanceof SQLExprHint)) continue;
            this.print0("[");
            hint.accept(this);
            this.print0("]");
        }
    }

    @Override
    protected void printSortedBy(List<SQLSelectOrderByItem> sortedBy) {
        if (sortedBy.size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORT BY (" : "sort by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
    }

    @Override
    protected void printPartitionBy(SQLCreateTableStatement x) {
        SQLPartitionBy partitionBy = x.getPartitioning();
        if (partitionBy == null) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "PARTITION BY " : "partition by ");
        partitionBy.accept(this);
    }

    @Override
    public boolean visit(SQLPartitionSingle x) {
        ImpalaSQLPartitionValue values = (ImpalaSQLPartitionValue)x.getValues();
        values.accept(this);
        return false;
    }

    @Override
    protected void printEncoding(SQLColumnDefinition x) {
        if (x.getEncode() != null) {
            this.print0(this.ucase ? " ENCODING " : " encoding ");
            x.getEncode().accept(this);
        }
    }

    @Override
    protected void printCompression(SQLColumnDefinition x) {
        if (x.getCompression() != null) {
            this.print0(this.ucase ? " COMPRESSION " : " compression ");
            x.getCompression().accept(this);
        }
    }

    @Override
    public boolean visit(SQLPartitionValue x) {
        if (x instanceof ImpalaSQLPartitionValue) {
            ImpalaSQLPartitionValue partitionValue = (ImpalaSQLPartitionValue)x;
            this.print0(this.ucase ? " PARTITION " : " partition ");
            if (partitionValue.getOperator() == SQLPartitionValue.Operator.Equal) {
                this.print0(this.ucase ? "VALUE" : "value");
                this.print0(" = ");
                if (partitionValue.getItems().size() == 1) {
                    this.printExpr(partitionValue.getItems().get(0), this.parameterized);
                } else {
                    this.print("(");
                    this.printAndAccept(partitionValue.getItems(), ", ", false);
                    this.print(')');
                }
            } else {
                if (partitionValue.getLeftBound() != null) {
                    this.print(partitionValue.getLeftBound());
                    this.printOperator(partitionValue.getLeftOperator());
                }
                this.print0(this.ucase ? "VALUES" : "values");
                if (partitionValue.getRightBound() != null) {
                    this.printOperator(partitionValue.getRightOperator());
                    this.print(partitionValue.getRightBound());
                }
            }
        }
        return false;
    }

    private void printOperator(SQLPartitionValue.Operator operator) {
        switch (operator) {
            case LessThan: {
                this.print0(" < ");
                break;
            }
            case LessThanEqual: {
                this.print0(" <= ");
                break;
            }
            case In: {
                this.print0(" IN ");
                break;
            }
            case List: {
                this.print0(" LIST ");
                break;
            }
            default: {
                throw new IllegalArgumentException("operator not support");
            }
        }
    }
}

