/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.redshift.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLTop;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftColumnEncode;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftColumnKey;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftCreateTableStatement;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftSelectQueryBlock;
import com.alibaba.druid.sql.dialect.redshift.visitor.RedshiftASTVisitor;

public class RedshiftOutputVisitor
extends PGOutputVisitor
implements RedshiftASTVisitor {
    public RedshiftOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.hologres;
    }

    public RedshiftOutputVisitor(StringBuilder appender) {
        super(appender);
        this.dbType = DbType.hologres;
    }

    @Override
    public boolean visit(RedshiftSelectQueryBlock x) {
        this.print0(this.ucase ? "SELECT " : "select ");
        SQLTop top = x.getTop();
        if (top != null) {
            this.visit(top);
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        }
        this.printSelectList(x.getSelectList());
        this.printInto(x);
        this.printFrom(x);
        this.printWhere(x);
        this.printHierarchical(x);
        this.printGroupBy(x);
        this.printQualify(x);
        this.printOrderBy(x);
        this.printFetchFirst(x);
        this.printAfterFetch(x);
        return false;
    }

    @Override
    protected void printInto(SQLSelectQueryBlock x) {
        if (x instanceof RedshiftSelectQueryBlock) {
            RedshiftSelectQueryBlock queryBlock = (RedshiftSelectQueryBlock)x;
            SQLExprTableSource into = x.getInto();
            if (into != null) {
                this.println();
                this.print0(this.ucase ? "INTO " : "into ");
                if (queryBlock.isInsertTemp()) {
                    this.print0(this.ucase ? "TEMP " : "temp ");
                }
                if (queryBlock.isInsertTemporary()) {
                    this.print0(this.ucase ? "TEMPORARY " : "temporary ");
                }
                if (queryBlock.isInsertTable()) {
                    this.print0(this.ucase ? "TABLE " : "table ");
                }
                into.accept(this);
            }
        } else {
            super.printInto(x);
        }
    }

    @Override
    public boolean visit(RedshiftCreateTableStatement x) {
        this.printCreateTable(x, false);
        this.println();
        if (x.getSelect() != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            x.getSelect().accept(this);
        }
        if (x.getBackup() != null) {
            this.print0(this.ucase ? "BACKUP " : "backup ");
            x.getBackup().accept(this);
            this.println();
        }
        if (x.getDistStyle() != null) {
            this.print0(this.ucase ? "DISTSTYLE " : "diststyle ");
            x.getDistStyle().accept(this);
            this.println();
        }
        if (x.getDistKey() != null) {
            this.print0(this.ucase ? "DISTKEY(" : "distkey(");
            x.getDistKey().accept(this);
            this.print0(")");
            this.println();
        }
        if (x.getSortKey() != null) {
            if (x.getSortKey().isCompound()) {
                this.print0(this.ucase ? "COMPOUND " : "compound ");
            } else if (x.getSortKey().isInterleaved()) {
                this.print0(this.ucase ? "INTERLEAVED " : "interleaved ");
            }
            if (!x.getSortKey().getColumns().isEmpty()) {
                this.print0(this.ucase ? "SORTKEY(" : "sortkey(");
                this.printAndAccept(x.getSortKey().getColumns(), ", ");
                this.print0(")");
            } else if (x.getSortKey().isAuto()) {
                this.print0(this.ucase ? "SORTKEY AUTO" : "sortkey auto");
            }
            this.println();
        }
        if (x.isEncodeAuto()) {
            this.print0(this.ucase ? "ENCODE AUTO" : "encode auto");
        }
        return false;
    }

    @Override
    public boolean visit(RedshiftColumnEncode x) {
        this.print0(this.ucase ? "ENCODE " : "encode ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(RedshiftColumnKey x) {
        if (x.isDistKey()) {
            this.print0(this.ucase ? "DISTKEY" : "distkey");
        }
        if (x.isSortKey()) {
            this.print0(this.ucase ? "SORTKEY" : "sortkey");
        }
        return false;
    }

    @Override
    protected void printGeneratedAlways(SQLColumnDefinition x, boolean parameterized) {
        SQLColumnDefinition.Identity identity;
        SQLExpr generatedAlwaysAs = x.getGeneratedAlwaysAs();
        if (generatedAlwaysAs != null) {
            this.print0(this.ucase ? " GENERATED BY DEFAULT AS " : " generated by default as ");
            this.printExpr(generatedAlwaysAs, parameterized);
        }
        if ((identity = x.getIdentity()) != null) {
            this.print(' ');
            identity.accept(this);
        }
    }

    @Override
    public boolean visit(SQLColumnDefinition.Identity x) {
        this.print0(this.ucase ? "IDENTITY" : "identity");
        Integer seed = x.getSeed();
        if (seed != null) {
            this.print0(" (");
            this.print(seed);
            this.print0(", ");
            this.print(x.getIncrement());
            this.print(')');
        }
        return false;
    }
}

