/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.spark.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLShowFunctionsStatement;
import com.alibaba.druid.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.druid.sql.dialect.spark.ast.stmt.SparkCacheTableStatement;
import com.alibaba.druid.sql.dialect.spark.ast.stmt.SparkCreateScanStatement;
import com.alibaba.druid.sql.dialect.spark.parser.SparkCreateTableParser;
import com.alibaba.druid.sql.dialect.spark.parser.SparkExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class SparkStatementParser
extends HiveStatementParser {
    public SparkStatementParser(String sql) {
        super(new SparkExprParser(sql));
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SparkCreateTableParser(this.exprParser);
    }

    @Override
    protected void alterTableUnset(SQLAlterTableStatement stmt) {
        this.acceptIdentifier("TBLPROPERTIES");
        this.accept(Token.LPAREN);
        this.exprParser.names(stmt.getUnsetTableOptions(), stmt);
        this.accept(Token.RPAREN);
    }

    @Override
    public SQLStatement parseCreateScan() {
        SparkCreateScanStatement stmt = new SparkCreateScanStatement();
        this.accept(Token.CREATE);
        this.acceptIdentifier("SCAN");
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            stmt.setOn(this.exprParser.name());
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            stmt.setUsing(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals("OPTIONS")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                stmt.addOption(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    @Override
    public SparkCacheTableStatement parseCache() {
        this.accept(Token.CACHE);
        SparkCacheTableStatement stmt = new SparkCacheTableStatement();
        if (this.lexer.identifierEquals("LAZY")) {
            this.lexer.nextToken();
            stmt.setLazy(true);
        }
        this.accept(Token.TABLE);
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals("OPTIONS")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                stmt.addOption(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            stmt.setAs(true);
        }
        if (!this.lexer.isEOF()) {
            SQLSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect query = selectParser.select();
            stmt.setQuery(query);
        }
        return stmt;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.identifierEquals(FnvHash.Constants.SHOW)) {
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.USER || this.lexer.identifierEquals(FnvHash.Constants.SYSTEM) || this.lexer.token() == Token.ALL || this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                SQLShowFunctionsStatement stmt = new SQLShowFunctionsStatement();
                if (!this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                    SQLName name = this.exprParser.name();
                    stmt.setKind(name);
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LIKE) {
                        this.lexer.nextToken();
                        SQLExpr like = this.exprParser.expr();
                        stmt.setLike(like);
                    }
                    statementList.add(stmt);
                    return true;
                }
            }
            this.lexer.reset(savePoint);
        }
        return super.parseStatementListDialect(statementList);
    }
}

