/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.DistributedByType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksAggregateKey;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksDuplicateKey;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksIndexDefinition;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateResourceStatement;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.druid.sql.dialect.starrocks.visitor.StarRocksASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.List;
import java.util.Locale;

public class StarRocksOutputVisitor
extends SQLASTOutputVisitor
implements StarRocksASTVisitor {
    public StarRocksOutputVisitor(StringBuilder appender) {
        super(appender);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    @Override
    protected void printEngine(SQLCreateTableStatement x) {
        SQLExpr engine;
        if (x instanceof StarRocksCreateTableStatement && (engine = ((StarRocksCreateTableStatement)x).getEngine()) != null) {
            this.print0(this.ucase ? " ENGINE = " : " engine = ");
            engine.accept(this);
        }
    }

    @Override
    public boolean visit(StarRocksCreateTableStatement x) {
        this.printCreateTable(x, false);
        this.printEngine(x);
        this.printUniqueKey(x);
        this.printComment(x.getComment());
        this.printPartitionBy(x);
        this.printDistributedBy(x);
        this.printOrderBy(x);
        this.printTableOptions(x);
        this.printSelectAs(x, true);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        if (x instanceof StarRocksCreateTableStatement) {
            return this.visit((StarRocksCreateTableStatement)x);
        }
        return super.visit(x);
    }

    @Override
    protected void printCreateTable(SQLCreateTableStatement x, boolean printSelect) {
        this.print0(this.ucase ? "CREATE " : "create ");
        this.printCreateTableFeatures(x);
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getTableSource().getExpr());
        this.printCreateTableAfterName(x);
        this.printTableElements(x.getTableElementList());
    }

    protected void printUniqueKey(SQLCreateTableStatement x) {
        if (x.getUnique() != null) {
            this.println();
            if (x.getUnique() instanceof StarRocksAggregateKey) {
                this.print0(this.ucase ? "AGGREGATE KEY (" : "aggregate key (");
            } else if (x.getUnique() instanceof StarRocksDuplicateKey) {
                this.print0(this.ucase ? "DUPLICATE KEY (" : "duplicate key (");
            } else if (x.getUnique() instanceof SQLPrimaryKeyImpl) {
                this.print0(this.ucase ? "PRIMARY KEY (" : "primary key (");
            } else {
                this.print0(this.ucase ? "UNIQUE KEY (" : "unique key (");
            }
            this.printAndAccept(x.getUnique().getColumns(), ", ");
            this.print0(")");
        }
    }

    protected void printDistributedBy(SQLCreateTableStatement x) {
        StarRocksCreateTableStatement createTable;
        if (x instanceof StarRocksCreateTableStatement && (createTable = (StarRocksCreateTableStatement)x).getDistributedByType() != null) {
            this.println();
            this.print0(this.ucase ? "DISTRIBUTED BY " : "distributed by ");
            DistributedByType distributedByType = createTable.getDistributedByType();
            if (DistributedByType.Random.equals((Object)distributedByType)) {
                this.print0(this.ucase ? "RANDOM BUCKETS" : "random buckets");
                if (createTable.getBuckets() > 0) {
                    this.print0(" ");
                    this.print0(String.valueOf(createTable.getBuckets()));
                }
            } else if (DistributedByType.Hash.equals((Object)distributedByType) && !createTable.getDistributedBy().isEmpty()) {
                this.print0(this.ucase ? "HASH (" : "hash (");
                this.printAndAccept(createTable.getDistributedBy(), ", ");
                this.print0(")");
                if (createTable.getBuckets() > 0) {
                    this.print0(this.ucase ? " BUCKETS " : " buckets ");
                    this.print0(String.valueOf(createTable.getBuckets()));
                }
            }
        }
    }

    protected void printOrderBy(SQLCreateTableStatement x) {
        if (x instanceof StarRocksCreateTableStatement) {
            StarRocksCreateTableStatement createTable = (StarRocksCreateTableStatement)x;
            this.printOrderBy(createTable.getOrderBy());
        }
    }

    @Override
    protected void printTableOptionsPrefix(SQLCreateTableStatement x) {
        this.println();
        this.print0(this.ucase ? "PROPERTIES (" : "properties (");
        this.incrementIndent();
        this.println();
    }

    @Override
    protected void printTableOptions(SQLCreateTableStatement statement) {
        StarRocksCreateTableStatement x;
        super.printTableOptions(statement);
        if (statement instanceof StarRocksCreateTableStatement && !(x = (StarRocksCreateTableStatement)statement).getBrokerProperties().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "BROKER PROPERTIES (" : "broker properties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (SQLAssignItem property : x.getBrokerProperties()) {
                this.printTableOption(property.getTarget(), property.getValue(), i);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print0(")");
        }
    }

    protected void print(List<? extends SQLExpr> exprList) {
        int size = exprList.size();
        if (size == 0) {
            return;
        }
        this.print0(" (");
        ++this.indentCount;
        this.println();
        for (int i = 0; i < size; ++i) {
            SQLExpr element = exprList.get(i);
            if (element instanceof SQLArrayExpr) {
                SQLArrayExpr array = (SQLArrayExpr)element;
                SQLExpr expr = array.getExpr();
                if (expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.ARRAY && this.printNameQuote) {
                    this.print0(((SQLIdentifierExpr)expr).getName());
                } else if (expr != null) {
                    expr.accept(this);
                }
                this.print('[');
                this.printAndAccept(array.getValues(), ", ");
                if (i != size - 1) {
                    this.print0(",");
                }
                this.print(']');
            } else {
                element.accept(this);
            }
            if (i != size - 1 && !(element instanceof SQLArrayExpr)) {
                this.print(',');
            }
            if (i == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print(')');
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        super.visit(x);
        if (x.getAsExpr() != null) {
            this.print(' ');
            this.print0(this.ucase ? "AS " : "as ");
            x.getAsExpr().accept(this);
        }
        if (x.getBitmap() != null) {
            this.print(' ');
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(this.ucase ? x.getBitmap().getText().toUpperCase(Locale.ROOT) : x.getBitmap().getText().toLowerCase(Locale.ROOT));
        }
        if (x.getIndexComment() != null) {
            this.print(' ');
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getIndexComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksCreateResourceStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        this.print0(this.ucase ? "RESOURCE " : "resource ");
        x.getName().accept(this);
        this.println();
        this.print0(this.ucase ? "PROPERTIES" : "properties");
        this.print(x.getProperties());
        return false;
    }

    @Override
    public boolean visit(StarRocksIndexDefinition x) {
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getIndexName().accept(this);
        this.print('(');
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        if (x.isUsingBitmap()) {
            this.print0(this.ucase ? " USING BITMAP" : " using bitmap");
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }
}

