/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadWorkbookHolder;
import com.alibaba.excel.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SheetUtils.class);

    private SheetUtils() {
    }

    public static ReadSheet match(ReadSheet readSheet, AnalysisContext analysisContext) {
        ReadWorkbookHolder readWorkbookHolder = analysisContext.readWorkbookHolder();
        if (readWorkbookHolder.getReadAll().booleanValue()) {
            return readSheet;
        }
        for (ReadSheet parameterReadSheet : readWorkbookHolder.getParameterSheetDataList()) {
            String parameterSheetName;
            boolean match;
            if (parameterReadSheet == null) continue;
            if (parameterReadSheet.getSheetNo() == null && parameterReadSheet.getSheetName() == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The first is read by default.");
                }
                parameterReadSheet.setSheetNo(0);
            }
            boolean bl = match = parameterReadSheet.getSheetNo() != null && parameterReadSheet.getSheetNo().equals(readSheet.getSheetNo());
            if (!match && !StringUtils.isEmpty(parameterSheetName = parameterReadSheet.getSheetName())) {
                boolean autoTrim = parameterReadSheet.getAutoTrim() != null && parameterReadSheet.getAutoTrim() != false || parameterReadSheet.getAutoTrim() == null && analysisContext.readWorkbookHolder().getGlobalConfiguration().getAutoTrim() != false;
                String sheetName = readSheet.getSheetName();
                if (autoTrim) {
                    parameterSheetName = parameterSheetName.trim();
                    sheetName = sheetName.trim();
                }
                match = parameterSheetName.equals(sheetName);
            }
            if (!match) continue;
            readSheet.copyBasicParameter(parameterReadSheet);
            return readSheet;
        }
        return null;
    }
}

