/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol;

import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.transport.ConnectionListener;
import com.alibaba.nls.client.transport.netty4.NettyWebSocketClient;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NlsClient {
    static Logger logger = LoggerFactory.getLogger(NlsClient.class);
    private static final String DEFAULT_SERVER_ADDR = "wss://nls-gateway.cn-shanghai.aliyuncs.com/ws/v1";
    NettyWebSocketClient client;
    String token;
    public static int connectMaxTryTimes = Integer.parseInt(System.getProperty("nls.ws.connect.max_try_times", "3"));
    public static int connectTimeout = Integer.parseInt(System.getProperty("nls.ws.connect.timeout", "5000"));

    public NlsClient() {
    }

    public NlsClient(String token) {
        try {
            this.token = token;
            this.client = new NettyWebSocketClient(DEFAULT_SERVER_ADDR);
        }
        catch (Exception e) {
            logger.error("fail to create NlsClient", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public NlsClient(String url, String token) {
        try {
            this.token = token;
            this.client = new NettyWebSocketClient(url);
        }
        catch (Exception e) {
            logger.error("fail to create NlsClient", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Connection connect(ConnectionListener listener) throws Exception {
        return this.connect(this.token, listener);
    }

    public Connection connect(String accessToken, ConnectionListener listener) throws Exception {
        return this.connect(this.token, listener, null);
    }

    public Connection connect(String accessToken, ConnectionListener listener, URI newUri) throws Exception {
        for (int i = 0; i < connectMaxTryTimes; ++i) {
            try {
                return this.client.connect(accessToken, listener, connectTimeout, newUri);
            }
            catch (Exception e) {
                if (i == 2) {
                    logger.error("failed to connect to server after 3 tries,error msg is :{}", (Object)e.getMessage());
                    throw e;
                }
                Thread.sleep(100L);
                logger.warn("failed to connect to server the {} time:{} ,try again ", (Object)i, (Object)e.getMessage());
                continue;
            }
        }
        return null;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public void shutdown(long quietTime, TimeUnit unit) {
        this.client.shutdown(quietTime, unit);
    }
}

