/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.asr;

import com.alibaba.fastjson.JSON;
import com.alibaba.nls.client.protocol.asr.SpeechRecognizer;
import com.alibaba.nls.client.protocol.asr.SpeechRecognizerResponse;
import com.alibaba.nls.client.transport.ConnectionListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpeechRecognizerListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(SpeechRecognizerListener.class);
    private SpeechRecognizer recognizer;

    public void setSpeechRecognizer(SpeechRecognizer recognizer) {
        this.recognizer = recognizer;
    }

    public void onRecognitionResultChanged(SpeechRecognizerResponse response) {
    }

    public void onRecognitionCompleted(SpeechRecognizerResponse response) {
    }

    public void onFail(int status, String reason) {
        this.logger.error("fail status:{},reasone:{}", (Object)status, (Object)reason);
    }

    public void onOpen() {
        this.logger.debug("connection is ok");
    }

    public void onClose(int closeCode, String reason) {
        if (this.recognizer != null) {
            this.recognizer.markClosed();
        }
        this.logger.info("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    public void onError(Throwable throwable) {
        this.logger.error(throwable.getMessage(), throwable);
    }

    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        SpeechRecognizerResponse response = (SpeechRecognizerResponse)((Object)JSON.parseObject((String)message, SpeechRecognizerResponse.class));
        if (this.isRecReady(response)) {
            this.recognizer.markReady();
        } else if (this.isRecResult(response)) {
            this.onRecognitionResultChanged(response);
        } else if (this.isRecComplete(response)) {
            this.onRecognitionCompleted(response);
            this.recognizer.markComplete();
        } else if (this.isTaskFailed(response)) {
            this.onFail(response.getStatus(), response.getStatusText());
            this.recognizer.markFail();
        } else {
            this.logger.error(message);
        }
    }

    public void onMessage(ByteBuffer message) {
    }

    private boolean isRecReady(SpeechRecognizerResponse response) {
        String name = response.getName();
        return name.equals("RecognitionStarted");
    }

    private boolean isRecResult(SpeechRecognizerResponse response) {
        String name = response.getName();
        return name.equals("RecognitionResultChanged");
    }

    private boolean isRecComplete(SpeechRecognizerResponse response) {
        String name = response.getName();
        return name.equals("RecognitionCompleted");
    }

    private boolean isTaskFailed(SpeechRecognizerResponse response) {
        String name = response.getName();
        return name.equals("TaskFailed");
    }
}

