/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx;

import com.alibaba.polardbx.MysqlDriver;
import com.alibaba.polardbx.NamedThreadFactory;
import com.alibaba.polardbx.common.AddressDecoder;
import com.alibaba.polardbx.common.XClusterInfo;
import com.alibaba.polardbx.common.XClusterNodeBasic;
import com.alibaba.polardbx.common.logging.Log;
import com.alibaba.polardbx.common.logging.LogFactory;
import com.alibaba.polardbx.dynamic.DynamicConfig;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class HaManager
extends Thread {
    private static final Log LOGGER = LogFactory.getLog(HaManager.class);
    private static final String BASIC_INFO_QUERY = "/* PolarDB-X-Driver HaManager */ select version(), @@cluster_id, @@port";
    private static final String LEGACY_XPORT_QUERY = "/* PolarDB-X-Driver HaManager */ select @@rpc_use_legacy_port, @@polarx_port";
    private static final String RPC_PORT_QUERY = "/* PolarDB-X-HA-Driver HaManager */ select @@rpc_port";
    private static final String CLUSTER_LOCAL_QUERY = "/* PolarDB-X-Driver HaManager */ select * from information_schema.alisql_cluster_local limit 1";
    private static final String CLUSTER_GLOBAL_QUERY = "/* PolarDB-X-Driver HaManager */ select * from information_schema.alisql_cluster_global";
    private static final String CHECK_LEADER_TRANSFER_QUERY = "/* PolarDB-X-Driver HaManager */ show global status like 'consensus_in_leader_transfer'";
    private static final String SHOW_MPP_QUERY = "/* PolarDB-X-HA-Driver HaManager */ show mpp";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss ZZZZ");
    private static final String JDBC_HA_CHECK_URL = "jdbc:mysql://%s:%d/?connectTimeout=%d&socketTimeout=%d&useUnicode=true&characterEncoding=utf8&autoReconnect=false&failOverReadOnly=false&rewriteBatchedStatements=true&allowMultiQueries=true&useServerPrepStmts=false";
    private static final String JDBC_DEFAULT_SSL_PROPERTY = "&useSSL=false";
    private final boolean isDN;
    private final Executor executor;
    private final String addresses;
    private final long clusterId;
    private final AtomicReference<String> user = new AtomicReference();
    private final AtomicReference<String> password = new AtomicReference();
    private final AtomicInteger haCheckConnectTimeoutMillis = new AtomicInteger(3000);
    private final AtomicInteger haCheckSocketTimeoutMillis = new AtomicInteger(3000);
    private final AtomicInteger haCheckIntervalMillis = new AtomicInteger(1000);
    private final AtomicInteger checkLeaderTransferringIntervalMillis = new AtomicInteger(100);
    private final AtomicInteger leaderTransferringWaitTimeoutMillis = new AtomicInteger(5000);
    private final AtomicReference<String> jsonFile = new AtomicReference();
    private final AtomicReference<Map<String, String>> sslSettings = new AtomicReference();
    private int globalPortGap = -8000;
    private final AtomicReference<List<XClusterNodeBasic>> clusterPeersRef = new AtomicReference();
    private final AtomicReference<XClusterNodeBasic> leaderRef = new AtomicReference();
    private final AtomicReference<List<String>> mppRef = new AtomicReference();
    private final AtomicInteger version = new AtomicInteger(0);
    private final AtomicReference<LeaderTransferInfo> leaderTransferInfoRef = new AtomicReference();
    private boolean ignoreVip;
    private final boolean ipv6;
    private static final ThreadPoolExecutor WORKER_POOL = new ThreadPoolExecutor(4, 16, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("HaWorker"));
    private static final Map<String, HaManager> MANAGERS = new ConcurrentHashMap<String, HaManager>();

    public HaManager(boolean isDN, Executor executor, String addresses, long clusterId, String user, String password, String jsonFile, boolean ignoreVip, boolean ipv6) {
        super("HA-Manager-" + addresses + '#' + (isDN ? Long.valueOf(clusterId) : "CN"));
        this.isDN = isDN;
        this.executor = executor;
        this.addresses = addresses;
        this.clusterId = clusterId;
        this.user.set(user);
        this.password.set(password);
        this.jsonFile.set(jsonFile);
        this.ignoreVip = ignoreVip;
        this.ipv6 = ipv6;
        this.setDaemon(true);
        this.start();
        if (isDN) {
            Thread leaderTransferCheckerThread = new Thread(this::leaderTransferCheckRoutine, "HA-Leader-Transfer-Checker-" + addresses + '#' + clusterId);
            leaderTransferCheckerThread.setDaemon(true);
            leaderTransferCheckerThread.start();
        }
    }

    public void setUserPassword(String user, String password) {
        this.user.set(user);
        this.password.set(password);
    }

    public void setHaCheckConnectTimeoutMillis(int timeout) {
        this.haCheckConnectTimeoutMillis.set(timeout);
    }

    public void setHaCheckSocketTimeoutMillis(int timeout) {
        this.haCheckSocketTimeoutMillis.set(timeout);
    }

    public void setHaCheckIntervalMillis(int interval) {
        this.haCheckIntervalMillis.set(interval);
    }

    public void setCheckLeaderTransferringIntervalMillis(int interval) {
        this.checkLeaderTransferringIntervalMillis.set(interval);
    }

    public void setLeaderTransferringWaitTimeoutMillis(int timeout) {
        this.leaderTransferringWaitTimeoutMillis.set(timeout);
    }

    public void setJsonFile(String jsonFile) {
        this.jsonFile.set(jsonFile);
    }

    public void setSslSettings(Map<String, String> sslSettings) {
        this.sslSettings.set(sslSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getProbeAddresses(List<XClusterNodeBasic> dynamic) {
        DynamicConfig nowConfig;
        HashSet<String> probeAddresses = new HashSet<String>(4);
        DynamicConfig dynamicConfig = nowConfig = DynamicConfig.load(this.jsonFile.get());
        synchronized (dynamicConfig) {
            if (this.isDN) {
                List<XClusterNodeBasic> cluster = nowConfig.getXCluster();
                if (cluster != null) {
                    if (dynamic != null) {
                        dynamic.addAll(cluster);
                    }
                    for (XClusterNodeBasic node : cluster) {
                        probeAddresses.add(node.getTag());
                    }
                }
            } else {
                List<String> mpp = nowConfig.getPolarDBX();
                if (mpp != null) {
                    probeAddresses.addAll(mpp);
                }
            }
        }
        AddressDecoder decoder = new AddressDecoder(this.addresses);
        probeAddresses.addAll(decoder.getAddressMap().keySet());
        return probeAddresses;
    }

    private static Connection connect(String host, int port, String user, String password, int connectTimeoutMillis, int socketTimeoutMillis, Map<String, String> sslSettings) throws SQLException {
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", password);
        String sslProperty = null == sslSettings || sslSettings.isEmpty() ? JDBC_DEFAULT_SSL_PROPERTY : "&" + sslSettings.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        return MysqlDriver.DRIVER.connect(String.format(JDBC_HA_CHECK_URL, host, port, connectTimeoutMillis, socketTimeoutMillis) + sslProperty, info);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private XClusterNodeBasic getNodeInfo(String address) {
        InetSocketAddress socketAddress = AddressDecoder.decode(address);
        try (Connection conn = HaManager.connect(socketAddress.getHostString(), socketAddress.getPort(), this.user.get(), this.password.get(), this.haCheckConnectTimeoutMillis.get(), this.haCheckSocketTimeoutMillis.get(), this.sslSettings.get());){
            XClusterNodeBasic xClusterNodeBasic;
            block82: {
                String updateTime;
                int xport;
                String leaderInfo;
                String role;
                String leader;
                int serverPort;
                long clusterId;
                String version;
                Statement stmt;
                block79: {
                    Object paxosAddr;
                    block80: {
                        List<XClusterNodeBasic> peers;
                        ResultSet rs;
                        block84: {
                            ResultSet rs2;
                            block74: {
                                XClusterNodeBasic ignore2;
                                block76: {
                                    block75: {
                                        block72: {
                                            ResultSet rs3;
                                            block73: {
                                                block83: {
                                                    block69: {
                                                        XClusterNodeBasic xClusterNodeBasic2;
                                                        block71: {
                                                            block70: {
                                                                stmt = conn.createStatement();
                                                                rs3 = stmt.executeQuery(BASIC_INFO_QUERY);
                                                                if (rs3.next()) {
                                                                    version = rs3.getString(1);
                                                                    clusterId = rs3.getLong(2);
                                                                    serverPort = rs3.getInt(3);
                                                                    break block69;
                                                                }
                                                                xClusterNodeBasic2 = null;
                                                                if (rs3 == null) break block70;
                                                                rs3.close();
                                                            }
                                                            if (stmt == null) break block71;
                                                            stmt.close();
                                                        }
                                                        return xClusterNodeBasic2;
                                                    }
                                                    if (rs3 != null) {
                                                        rs3.close();
                                                    }
                                                    break block83;
                                                    {
                                                        catch (Throwable throwable) {
                                                            if (rs3 != null) {
                                                                try {
                                                                    rs3.close();
                                                                }
                                                                catch (Throwable throwable2) {
                                                                    throwable.addSuppressed(throwable2);
                                                                }
                                                            }
                                                            throw throwable;
                                                        }
                                                    }
                                                }
                                                if (clusterId == this.clusterId) break block72;
                                                rs3 = null;
                                                if (stmt == null) break block73;
                                                stmt.close();
                                            }
                                            return rs3;
                                        }
                                        rs2 = stmt.executeQuery(CLUSTER_LOCAL_QUERY);
                                        if (rs2.next()) {
                                            leader = rs2.getString("CURRENT_LEADER");
                                            role = rs2.getString("ROLE");
                                            try {
                                                String ip = rs2.getString("LEADER_IP");
                                                int port = rs2.getInt("LEADER_PORT");
                                                if (ip == null || ip.isEmpty() || port == 0) {
                                                    leaderInfo = null;
                                                    break block74;
                                                }
                                                if (ip.contains(":")) {
                                                    leaderInfo = '[' + ip + "]:" + port;
                                                    break block74;
                                                }
                                                leaderInfo = ip + ":" + port;
                                            }
                                            catch (SQLException ignore2) {
                                                leaderInfo = null;
                                            }
                                            break block74;
                                        }
                                        ignore2 = null;
                                        if (rs2 == null) break block75;
                                        rs2.close();
                                    }
                                    if (stmt == null) break block76;
                                    stmt.close();
                                }
                                return ignore2;
                            }
                            if (rs2 != null) {
                                rs2.close();
                            }
                            break block84;
                            {
                                catch (Throwable ignore2) {
                                    if (rs2 != null) {
                                        try {
                                            rs2.close();
                                        }
                                        catch (Throwable port) {
                                            ignore2.addSuppressed(port);
                                        }
                                    }
                                    throw ignore2;
                                }
                            }
                        }
                        xport = -1;
                        try {
                            rs = stmt.executeQuery(LEGACY_XPORT_QUERY);
                            try {
                                if (rs.next() && rs.getBoolean(1)) {
                                    xport = rs.getInt(2);
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (NumberFormatException | SQLException ignore) {
                            xport = -1;
                        }
                        if (-1 == xport) {
                            rs = stmt.executeQuery(RPC_PORT_QUERY);
                            try {
                                if (rs.next()) {
                                    xport = rs.getInt(1);
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        updateTime = ZonedDateTime.now().format(DATE_FORMAT);
                        if (role.equalsIgnoreCase("Leader")) break block79;
                        if (leader != null) {
                            paxosAddr = AddressDecoder.decode(leader);
                            String tag = leaderInfo != null && this.ipv6 ? leaderInfo : ((InetSocketAddress)paxosAddr).getHostString() + ":" + (((InetSocketAddress)paxosAddr).getPort() + this.globalPortGap);
                            peers = Collections.singletonList(new XClusterNodeBasic(tag, ((InetSocketAddress)paxosAddr).getHostString(), -1, -1, ((InetSocketAddress)paxosAddr).getPort(), "Leader", null, version, clusterId, leaderInfo, updateTime));
                        } else {
                            peers = null;
                        }
                        paxosAddr = new XClusterNodeBasic(address, socketAddress.getHostString(), socketAddress.getPort(), xport, -1, role, peers, version, clusterId, null, updateTime);
                        if (stmt == null) break block80;
                        stmt.close();
                    }
                    return paxosAddr;
                }
                try {
                    int portGap;
                    if (null == leader) {
                        throw new IllegalStateException("Can't get leader from local cluster system table while myself is leader.");
                    }
                    InetSocketAddress paxosAddr = AddressDecoder.decode(leader);
                    int paxosPort = paxosAddr.getPort();
                    this.globalPortGap = portGap = serverPort - paxosPort;
                    String leaderRealIp = null;
                    ArrayList<XClusterNodeBasic> peers = new ArrayList<XClusterNodeBasic>();
                    try (ResultSet rs = stmt.executeQuery(CLUSTER_GLOBAL_QUERY);){
                        while (rs.next()) {
                            String peerServerInfo;
                            InetSocketAddress peerPaxosAddr = AddressDecoder.decode(rs.getString("IP_PORT"));
                            String peerHost = peerPaxosAddr.getHostString();
                            int peerPaxosPort = peerPaxosAddr.getPort();
                            int peerPort = peerPaxosPort + portGap;
                            String peerRole = rs.getString("ROLE");
                            boolean peerIsLeader = peerRole.equalsIgnoreCase("Leader");
                            try {
                                String peerServerIp = rs.getString("SERVER_IP");
                                int peerServerPort = rs.getInt("SERVER_PORT");
                                peerServerInfo = peerServerIp == null || peerServerIp.isEmpty() || peerServerPort == 0 ? null : (peerServerIp.contains(":") ? '[' + peerServerIp + "]:" + peerServerPort : peerServerIp + ":" + peerServerPort);
                            }
                            catch (SQLException ignore) {
                                peerServerInfo = null;
                            }
                            peers.add(new XClusterNodeBasic(peerServerInfo != null && this.ipv6 ? peerServerInfo : peerHost + ':' + (peerIsLeader ? serverPort : peerPort), peerHost, peerIsLeader ? serverPort : peerPort, peerIsLeader ? xport : -1, peerPaxosPort, peerRole, null, version, clusterId, peerServerInfo, updateTime));
                            if (!peerIsLeader) continue;
                            leaderRealIp = peerHost;
                        }
                    }
                    peers.sort(Comparator.comparing(XClusterNodeBasic::getTag));
                    xClusterNodeBasic = new XClusterNodeBasic(leaderInfo != null && this.ipv6 ? leaderInfo : address, null == leaderRealIp ? socketAddress.getHostString() : leaderRealIp, null == leaderRealIp ? socketAddress.getPort() : serverPort, xport, paxosPort, role, Collections.unmodifiableList(peers), version, clusterId, leaderInfo, updateTime);
                    if (stmt == null) break block82;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return xClusterNodeBasic;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Set<String> getMppInfo(String address) {
        InetSocketAddress socketAddress = AddressDecoder.decode(address);
        try (Connection conn = HaManager.connect(socketAddress.getHostString(), socketAddress.getPort(), this.user.get(), this.password.get(), this.haCheckConnectTimeoutMillis.get(), this.haCheckSocketTimeoutMillis.get(), this.sslSettings.get());){
            HashSet<String> hashSet;
            block22: {
                Statement stmt = conn.createStatement();
                try {
                    HashSet<String> mppInfo = new HashSet<String>();
                    try (ResultSet rs = stmt.executeQuery(SHOW_MPP_QUERY);){
                        while (rs.next()) {
                            if (!rs.getString(3).equalsIgnoreCase("W")) continue;
                            mppInfo.add(rs.getString(2));
                        }
                    }
                    hashSet = mppInfo;
                    if (stmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static boolean mayBecomeOrKnowLeader(String role) {
        return role.equalsIgnoreCase("Leader") || role.equalsIgnoreCase("Follower") || role.equalsIgnoreCase("Candidate") || role.equalsIgnoreCase("Learner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dnHaChecker() {
        while (true) {
            boolean noLeaderExists;
            boolean unknownLeaderExists;
            block32: {
                unknownLeaderExists = false;
                noLeaderExists = false;
                try {
                    String string;
                    DynamicConfig nowConfig;
                    List<XClusterNodeBasic> peers;
                    ArrayList<XClusterNodeBasic> lastNodes = new ArrayList<XClusterNodeBasic>(3);
                    Set<String> probeAddresses = this.getProbeAddresses(lastNodes);
                    HashMap<String, XClusterNodeBasic> nodes = new HashMap<String, XClusterNodeBasic>(probeAddresses.size());
                    CompletableFuture.allOf((CompletableFuture[])probeAddresses.stream().map(address -> CompletableFuture.runAsync(() -> {
                        block5: {
                            try {
                                XClusterNodeBasic info = this.getNodeInfo((String)address);
                                if (info == null) break block5;
                                Map map = nodes;
                                synchronized (map) {
                                    nodes.put(info.getTag(), info);
                                }
                            }
                            catch (Throwable t) {
                                LOGGER.error(t.getMessage(), t);
                            }
                        }
                    }, this.executor)).toArray(CompletableFuture[]::new)).join();
                    Object leader = null;
                    for (XClusterNodeBasic node2 : nodes.values()) {
                        if (!node2.getRole().equalsIgnoreCase("Leader") || !node2.getTag().equals(node2.getHost() + ':' + node2.getPort()) && !node2.getTag().equals(node2.getServerInfo())) continue;
                        if (null == leader) {
                            leader = node2;
                            continue;
                        }
                        throw new IllegalStateException("More than one leader found.");
                    }
                    if (null == leader && !this.ignoreVip) {
                        for (Object node : nodes.values()) {
                            if (!((XClusterNodeBasic)node).getRole().equalsIgnoreCase("Leader")) continue;
                            leader = node;
                            break;
                        }
                    }
                    if (leader != null) {
                        peers = ((XClusterNodeBasic)leader).getPeers();
                        if (peers != null) {
                            peers.forEach(x -> {
                                XClusterNodeBasic existing;
                                if (HaManager.mayBecomeOrKnowLeader(x.getRole()) && (existing = nodes.putIfAbsent(x.getTag(), (XClusterNodeBasic)x)) != null && (-1 == existing.getPaxosPort() || null == existing.getServerInfo())) {
                                    nodes.put(x.getTag(), new XClusterNodeBasic(existing.getTag(), existing.getHost(), existing.getPort(), existing.getXport(), x.getPaxosPort(), existing.getRole(), existing.getPeers(), existing.getVersion(), existing.getClusterId(), null == existing.getServerInfo() ? x.getServerInfo() : existing.getServerInfo(), existing.getUpdateTime()));
                                }
                            });
                        }
                    } else {
                        Object node;
                        ArrayList visit = new ArrayList(nodes.values());
                        node = visit.iterator();
                        while (node.hasNext()) {
                            XClusterNodeBasic node3 = (XClusterNodeBasic)node.next();
                            if (node3.getPeers() == null) continue;
                            unknownLeaderExists = true;
                            node3.getPeers().forEach(x -> nodes.putIfAbsent(x.getTag(), (XClusterNodeBasic)x));
                        }
                        if (!unknownLeaderExists) {
                            XClusterNodeBasic lastLeader = null;
                            for (XClusterNodeBasic xClusterNodeBasic : lastNodes) {
                                if (!xClusterNodeBasic.getRole().equalsIgnoreCase("Leader") && !xClusterNodeBasic.getRole().equalsIgnoreCase("LastLeader")) continue;
                                lastLeader = xClusterNodeBasic;
                                break;
                            }
                            if (lastLeader != null) {
                                List<XClusterNodeBasic> peers2 = lastLeader.getPeers();
                                if (!nodes.containsKey(lastLeader.getTag())) {
                                    nodes.put(lastLeader.getTag(), new XClusterNodeBasic(lastLeader.getTag(), lastLeader.getHost(), lastLeader.getPort(), lastLeader.getXport(), lastLeader.getPaxosPort(), "LastLeader", peers2, lastLeader.getVersion(), lastLeader.getClusterId(), lastLeader.getServerInfo(), lastLeader.getUpdateTime()));
                                }
                                if (peers2 != null) {
                                    peers2.forEach(x -> {
                                        String role = x.getRole();
                                        if (HaManager.mayBecomeOrKnowLeader(role)) {
                                            nodes.putIfAbsent(x.getTag(), new XClusterNodeBasic(x.getTag(), x.getHost(), x.getPort(), x.getXport(), x.getPaxosPort(), role.startsWith("Last") ? role : "Last" + role, x.getPeers(), x.getVersion(), x.getClusterId(), x.getServerInfo(), x.getUpdateTime()));
                                        }
                                    });
                                }
                            }
                            noLeaderExists = true;
                        }
                    }
                    peers = Collections.unmodifiableList(nodes.values().stream().sorted(Comparator.comparing(XClusterNodeBasic::getTag)).collect(Collectors.toList()));
                    this.clusterPeersRef.set(peers);
                    String json = this.jsonFile.get();
                    DynamicConfig dynamicConfig = nowConfig = DynamicConfig.load(json);
                    synchronized (dynamicConfig) {
                        if (!peers.equals(nowConfig.getXCluster())) {
                            nowConfig.setXCluster(peers);
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info("Backend cluster state changed to: " + DynamicConfig.GSON.toJson(peers));
                            }
                            DynamicConfig.save(json);
                        }
                    }
                    if (leader != null && (string = ((XClusterNodeBasic)leader).getVersion()) != null) {
                        char ch;
                        int limit;
                        for (limit = 0; limit < string.length() && ((ch = string.charAt(limit)) >= '0' && ch <= '9' || ch == '.'); ++limit) {
                        }
                        String[] split = string.substring(0, limit).split("\\.");
                        if (split.length >= 3) {
                            this.version.set(10000 * Integer.parseInt(split[0]) + 100 * Integer.parseInt(split[1]) + Integer.parseInt(split[2]));
                        }
                    }
                    if (leader == null) break block32;
                    AtomicReference<XClusterNodeBasic> atomicReference = this.leaderRef;
                    synchronized (atomicReference) {
                        this.leaderRef.set((XClusterNodeBasic)leader);
                        this.leaderRef.notifyAll();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("HaManager error", t);
                }
            }
            try {
                XClusterNodeBasic leader = this.leaderRef.get();
                LeaderTransferInfo transferInfo = this.leaderTransferInfoRef.get();
                int interval = leader != null && transferInfo != null && transferInfo.tag.equals(leader.getTag()) && System.nanoTime() - transferInfo.nanos < TimeUnit.MILLISECONDS.toNanos(this.leaderTransferringWaitTimeoutMillis.get()) ? Math.min(100, this.haCheckIntervalMillis.get()) : this.haCheckIntervalMillis.get();
                HaManager haManager = this;
                synchronized (haManager) {
                    this.wait(unknownLeaderExists ? (long)Math.min(500, interval) : (long)(noLeaderExists ? Math.min(1000, interval) : interval));
                    continue;
                }
            }
            catch (Throwable t) {
                LOGGER.error("HaManager sleep error", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cnHaChecker() {
        while (true) {
            boolean noNodes;
            block16: {
                noNodes = true;
                try {
                    DynamicConfig nowConfig;
                    Set<String> probeAddresses = this.getProbeAddresses(null);
                    HashSet mpp = new HashSet(4);
                    HashSet validSet = new HashSet(probeAddresses.size());
                    CompletableFuture.allOf((CompletableFuture[])probeAddresses.stream().map(address -> CompletableFuture.runAsync(() -> {
                        block8: {
                            try {
                                Set<String> info = this.getMppInfo((String)address);
                                if (info == null) break block8;
                                Set set = mpp;
                                synchronized (set) {
                                    mpp.addAll(info);
                                }
                                if (!info.contains(address) && this.ignoreVip) break block8;
                                set = validSet;
                                synchronized (set) {
                                    validSet.add(address);
                                }
                            }
                            catch (Throwable t) {
                                LOGGER.error(t.getMessage(), t);
                            }
                        }
                    }, this.executor)).toArray(CompletableFuture[]::new)).join();
                    List<String> peers = Collections.unmodifiableList(mpp.stream().sorted().collect(Collectors.toList()));
                    String json = this.jsonFile.get();
                    DynamicConfig dynamicConfig = nowConfig = DynamicConfig.load(json);
                    synchronized (dynamicConfig) {
                        if (!peers.equals(nowConfig.getPolarDBX())) {
                            nowConfig.setPolarDBX(peers);
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info("Backend CN MPP changed to: {}" + DynamicConfig.GSON.toJson(peers));
                            }
                            DynamicConfig.save(json);
                        }
                    }
                    List validPeers = Collections.unmodifiableList(validSet.stream().sorted().collect(Collectors.toList()));
                    if (validPeers.isEmpty()) break block16;
                    noNodes = false;
                    AtomicReference<List<String>> atomicReference = this.mppRef;
                    synchronized (atomicReference) {
                        this.mppRef.set(validPeers);
                        this.mppRef.notifyAll();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("HaManager error", t);
                }
            }
            try {
                HaManager t = this;
                synchronized (t) {
                    this.wait(noNodes ? (long)Math.min(500, this.haCheckIntervalMillis.get()) : (long)this.haCheckIntervalMillis.get());
                    continue;
                }
            }
            catch (Throwable t) {
                LOGGER.error("HaManager sleep error", t);
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        if (this.isDN) {
            this.dnHaChecker();
        } else {
            this.cnHaChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaderTransferCheckRoutine() {
        String lastTag = null;
        Connection lastConn = null;
        while (true) {
            block27: {
                try {
                    Boolean isTransferring;
                    XClusterNodeBasic leader;
                    block28: {
                        leader = this.leaderRef.get();
                        if (leader == null) break block27;
                        if (null == lastTag || null == lastConn || !lastTag.equals(leader.getTag())) {
                            lastTag = leader.getTag();
                            if (lastConn != null) {
                                lastConn.close();
                            }
                            InetSocketAddress addr = AddressDecoder.decode(leader.getTag());
                            lastConn = HaManager.connect(addr.getHostString(), addr.getPort(), this.user.get(), this.password.get(), this.haCheckConnectTimeoutMillis.get(), this.haCheckSocketTimeoutMillis.get(), this.sslSettings.get());
                        }
                        isTransferring = null;
                        try (Statement stmt = lastConn.createStatement();
                             ResultSet rs = stmt.executeQuery(CHECK_LEADER_TRANSFER_QUERY);){
                            while (rs.next()) {
                                isTransferring = rs.getBoolean(2);
                            }
                        }
                        catch (Throwable ignore) {
                            isTransferring = null;
                            lastTag = null;
                            if (lastConn == null) break block28;
                            lastConn.close();
                            lastConn = null;
                        }
                    }
                    if (isTransferring != null && isTransferring.booleanValue()) {
                        this.leaderTransferInfoRef.set(new LeaderTransferInfo(leader.getTag(), System.nanoTime()));
                        HaManager ignore = this;
                        synchronized (ignore) {
                            this.notifyAll();
                            break block27;
                        }
                    }
                    LeaderTransferInfo transferInfo = this.leaderTransferInfoRef.get();
                    if (transferInfo != null && System.nanoTime() - transferInfo.nanos > TimeUnit.MILLISECONDS.toNanos(this.leaderTransferringWaitTimeoutMillis.get())) {
                        this.leaderTransferInfoRef.compareAndSet(transferInfo, null);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("HaManager leaderTransferCheckRoutine error", t);
                }
            }
            try {
                Thread.sleep(this.checkLeaderTransferringIntervalMillis.get());
                continue;
            }
            catch (Throwable t) {
                LOGGER.error("HaManager leaderTransferCheckRoutine sleep error", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableAddressWithWait(long timeout) throws SQLException {
        long timeoutNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (true) {
            AtomicReference<List<String>> leader;
            long nowNanos;
            if ((nowNanos = System.nanoTime()) - timeoutNanos >= 0L) {
                if (this.isDN && (leader = this.leaderRef.get()) != null) {
                    return ((XClusterNodeBasic)((Object)leader)).getTag();
                }
                throw new SQLException("Communications link failure\n\nNo leader found in " + timeout + " ms.", "08S01", 0);
            }
            try {
                long millis;
                if (this.isDN) {
                    leader = this.leaderRef;
                    synchronized (leader) {
                        XClusterNodeBasic leader2 = this.leaderRef.get();
                        if (leader2 != null) {
                            LeaderTransferInfo transferInfo = this.leaderTransferInfoRef.get();
                            long waitTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(this.leaderTransferringWaitTimeoutMillis.get());
                            if (transferInfo != null && transferInfo.tag.equals(leader2.getTag()) && nowNanos - transferInfo.nanos < waitTimeoutNanos) {
                                long millis2 = TimeUnit.NANOSECONDS.toMillis(Math.min(timeoutNanos - nowNanos, transferInfo.nanos + waitTimeoutNanos - nowNanos));
                                this.leaderRef.wait(Math.max(1L, millis2));
                                continue;
                            }
                            return leader2.getTag();
                        }
                        millis = TimeUnit.NANOSECONDS.toMillis(timeoutNanos - nowNanos);
                        this.leaderRef.wait(Math.max(1L, millis));
                        continue;
                    }
                }
                leader = this.mppRef;
                synchronized (leader) {
                    List<String> mpp = this.mppRef.get();
                    if (mpp != null && !mpp.isEmpty()) {
                        return mpp.get(ThreadLocalRandom.current().nextInt(mpp.size()));
                    }
                    millis = TimeUnit.NANOSECONDS.toMillis(timeoutNanos - nowNanos);
                    this.mppRef.wait(Math.max(1L, millis));
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isLeaderTransferring(String tag) {
        LeaderTransferInfo transferInfo = this.leaderTransferInfoRef.get();
        return transferInfo != null && transferInfo.tag.equals(tag) && System.nanoTime() - transferInfo.nanos < TimeUnit.MILLISECONDS.toNanos(this.leaderTransferringWaitTimeoutMillis.get());
    }

    public int getVersion() {
        return this.version.get();
    }

    public static long probeClusterId(XClusterInfo clusterInfo) throws SQLException {
        return HaManager.probeClusterId(clusterInfo, null);
    }

    public static long probeClusterId(XClusterInfo clusterInfo, Map<String, String> sslSettings) throws SQLException {
        AddressDecoder decoder = new AddressDecoder(clusterInfo.getAddresses());
        InetSocketAddress[] values = decoder.getAddressMap().values().toArray(new InetSocketAddress[0]);
        if (0 == values.length) {
            throw new SQLException("Invalid addresses: " + clusterInfo.getAddresses());
        }
        InetSocketAddress address = values[ThreadLocalRandom.current().nextInt(values.length)];
        try (Connection conn = HaManager.connect(address.getHostString(), address.getPort(), clusterInfo.getUser(), clusterInfo.getPassword(), clusterInfo.getHaCheckConnectTimeoutMillis(), clusterInfo.getHaCheckSocketTimeoutMillis(), sslSettings);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(BASIC_INFO_QUERY);){
            if (rs.next()) {
                if (rs.getString(1).toUpperCase().contains("-TDDL-")) {
                    throw new SQLException("Unknown system variable cluster_id");
                }
                long l = rs.getLong(2);
                return l;
            }
            throw new SQLException("Invalid result from " + address);
        }
    }

    private static String genTag(XClusterInfo clusterInfo) {
        return clusterInfo.getAddresses() + '#' + (-1L == clusterInfo.getClusterId() ? "" : Long.toString(clusterInfo.getClusterId()));
    }

    public static HaManager getManager(XClusterInfo clusterInfo) throws SQLException {
        return HaManager.getManager(clusterInfo, null, true);
    }

    public static HaManager getManager(XClusterInfo clusterInfo, Map<String, String> sslSettings, boolean ignoreVip) throws SQLException {
        String tag = HaManager.genTag(clusterInfo);
        HaManager manager = MANAGERS.get(tag);
        if (null == manager) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (-1L == clusterInfo.getClusterId()) {
                try {
                    long clusterId = HaManager.probeClusterId(clusterInfo, sslSettings);
                    boolean ipv6 = new AddressDecoder(clusterInfo.getAddresses()).getAddressMap().values().stream().map(InetSocketAddress::getAddress).anyMatch(i -> i instanceof Inet6Address);
                    String jsonFile = null == clusterInfo.getJsonFile() ? tmpDir + "/XCluster-" + clusterId + (ipv6 ? "-IPv6" : "-IPv4") + ".json" : clusterInfo.getJsonFile();
                    manager = MANAGERS.computeIfAbsent(tag, key -> new HaManager(true, WORKER_POOL, clusterInfo.getAddresses(), clusterId, clusterInfo.getUser(), clusterInfo.getPassword(), jsonFile, ignoreVip, ipv6));
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("Unknown system variable cluster_id")) {
                        String jsonFile = null == clusterInfo.getJsonFile() ? tmpDir + "/PolarDB-X-" + clusterInfo.getAddresses() + ".json" : clusterInfo.getJsonFile();
                        manager = MANAGERS.computeIfAbsent(tag, key -> new HaManager(false, WORKER_POOL, clusterInfo.getAddresses(), -1L, clusterInfo.getUser(), clusterInfo.getPassword(), jsonFile, ignoreVip, false));
                    }
                    throw e;
                }
            } else {
                boolean ipv6 = new AddressDecoder(clusterInfo.getAddresses()).getAddressMap().values().stream().map(InetSocketAddress::getAddress).anyMatch(i -> i instanceof Inet6Address);
                String jsonFile = null == clusterInfo.getJsonFile() ? tmpDir + "/XCluster-" + clusterInfo.getClusterId() + (ipv6 ? "-IPv6" : "-IPv4") + ".json" : clusterInfo.getJsonFile();
                manager = MANAGERS.computeIfAbsent(tag, key -> new HaManager(true, WORKER_POOL, clusterInfo.getAddresses(), clusterInfo.getClusterId(), clusterInfo.getUser(), clusterInfo.getPassword(), jsonFile, ignoreVip, ipv6));
            }
        } else {
            manager.setUserPassword(clusterInfo.getUser(), clusterInfo.getPassword());
            if (clusterInfo.getJsonFile() != null) {
                manager.setJsonFile(clusterInfo.getJsonFile());
            }
        }
        manager.setHaCheckConnectTimeoutMillis(clusterInfo.getHaCheckConnectTimeoutMillis());
        manager.setHaCheckSocketTimeoutMillis(clusterInfo.getHaCheckSocketTimeoutMillis());
        manager.setHaCheckIntervalMillis(clusterInfo.getHaCheckIntervalMillis());
        manager.setCheckLeaderTransferringIntervalMillis(clusterInfo.getCheckLeaderTransferringIntervalMillis());
        manager.setLeaderTransferringWaitTimeoutMillis(clusterInfo.getLeaderTransferringWaitTimeoutMillis());
        if (null == sslSettings) {
            manager.setSslSettings(null);
        } else {
            manager.setSslSettings(Collections.unmodifiableMap(new HashMap<String, String>(sslSettings)));
        }
        manager.ignoreVip = ignoreVip;
        return manager;
    }

    public AtomicReference<XClusterNodeBasic> getLeaderRef() {
        return this.leaderRef;
    }

    public AtomicReference<List<String>> getMppRef() {
        return this.mppRef;
    }

    private static class LeaderTransferInfo {
        public final String tag;
        public final long nanos;

        public LeaderTransferInfo(String tag, long nanos) {
            this.tag = tag;
            this.nanos = nanos;
        }
    }
}

