/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx;

import com.alibaba.polardbx.common.logging.Log;
import com.alibaba.polardbx.common.logging.LogFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Log LOGGER = LogFactory.getLog(NamedThreadFactory.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(0);
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean isDaemon;
    private final Thread.UncaughtExceptionHandler handler = (t, e) -> LOGGER.error(e.toString(), e);

    public NamedThreadFactory(String prefix) {
        this(prefix, true);
    }

    public NamedThreadFactory(String prefix, boolean daemon) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        this.isDaemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.isDaemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setUncaughtExceptionHandler(this.handler);
        return t;
    }
}

