/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool;

import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import com.alibaba.ttl.threadpool.ComparableComparator;
import com.alibaba.ttl.threadpool.DisableInheritableThreadFactory;
import com.alibaba.ttl.threadpool.DisableInheritableThreadFactoryWrapper;
import com.alibaba.ttl.threadpool.ExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.ExecutorTtlWrapper;
import com.alibaba.ttl.threadpool.ScheduledExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.TtlRunnableUnwrapComparator;
import com.alibaba.ttl.threadpool.agent.TtlAgent;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public final class TtlExecutors {
    private static final Comparator<Runnable> INSTANCE = new TtlRunnableUnwrapComparator(ComparableComparator.INSTANCE);

    @Nullable
    public static Executor getTtlExecutor(@Nullable Executor executor) {
        if (TtlAgent.isTtlAgentLoaded() || null == executor || executor instanceof TtlEnhanced) {
            return executor;
        }
        return new ExecutorTtlWrapper(executor, true);
    }

    @Nullable
    public static ExecutorService getTtlExecutorService(@Nullable ExecutorService executorService) {
        if (TtlAgent.isTtlAgentLoaded() || executorService == null || executorService instanceof TtlEnhanced) {
            return executorService;
        }
        return new ExecutorServiceTtlWrapper(executorService, true);
    }

    @Nullable
    public static ScheduledExecutorService getTtlScheduledExecutorService(@Nullable ScheduledExecutorService scheduledExecutorService) {
        if (TtlAgent.isTtlAgentLoaded() || scheduledExecutorService == null || scheduledExecutorService instanceof TtlEnhanced) {
            return scheduledExecutorService;
        }
        return new ScheduledExecutorServiceTtlWrapper(scheduledExecutorService, true);
    }

    public static <T extends Executor> boolean isTtlWrapper(@Nullable T executor) {
        return executor instanceof TtlWrapper;
    }

    @Nullable
    public static <T extends Executor> T unwrap(@Nullable T executor) {
        if (!TtlExecutors.isTtlWrapper(executor)) {
            return executor;
        }
        return (T)((ExecutorTtlWrapper)executor).unwrap();
    }

    @Nullable
    public static ThreadFactory getDisableInheritableThreadFactory(@Nullable ThreadFactory threadFactory) {
        if (threadFactory == null || TtlExecutors.isDisableInheritableThreadFactory(threadFactory)) {
            return threadFactory;
        }
        return new DisableInheritableThreadFactoryWrapper(threadFactory);
    }

    @NonNull
    public static ThreadFactory getDefaultDisableInheritableThreadFactory() {
        return TtlExecutors.getDisableInheritableThreadFactory(Executors.defaultThreadFactory());
    }

    public static boolean isDisableInheritableThreadFactory(@Nullable ThreadFactory threadFactory) {
        return threadFactory instanceof DisableInheritableThreadFactory;
    }

    @Nullable
    public static ThreadFactory unwrap(@Nullable ThreadFactory threadFactory) {
        if (!TtlExecutors.isDisableInheritableThreadFactory(threadFactory)) {
            return threadFactory;
        }
        return ((DisableInheritableThreadFactory)threadFactory).unwrap();
    }

    @Nullable
    public static Comparator<Runnable> getTtlRunnableUnwrapComparator(@Nullable Comparator<Runnable> comparator) {
        if (comparator == null || TtlExecutors.isTtlRunnableUnwrapComparator(comparator)) {
            return comparator;
        }
        return new TtlRunnableUnwrapComparator(comparator);
    }

    @NonNull
    public static Comparator<Runnable> getTtlRunnableUnwrapComparatorForComparableRunnable() {
        return INSTANCE;
    }

    public static boolean isTtlRunnableUnwrapComparator(@Nullable Comparator<Runnable> comparator) {
        return comparator instanceof TtlRunnableUnwrapComparator;
    }

    @Nullable
    public static Comparator<Runnable> unwrap(@Nullable Comparator<Runnable> comparator) {
        if (!TtlExecutors.isTtlRunnableUnwrapComparator(comparator)) {
            return comparator;
        }
        return ((TtlRunnableUnwrapComparator)comparator).unwrap();
    }

    private TtlExecutors() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

