/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class TtlTransformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(TtlTransformer.class);
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    private static final byte[] NO_TRANSFORM = null;
    private final List<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();

    TtlTransformer(List<? extends JavassistTransformlet> transformletList) {
        for (JavassistTransformlet javassistTransformlet : transformletList) {
            this.transformletList.add(javassistTransformlet);
            logger.info("[TtlTransformer] add Transformlet " + javassistTransformlet.getClass() + " success");
        }
    }

    @Override
    public final byte[] transform(@Nullable ClassLoader loader, @Nullable String classFile, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, @NonNull byte[] classFileBuffer) {
        try {
            if (classFile == null) {
                return NO_TRANSFORM;
            }
            String className = TtlTransformer.toClassName(classFile);
            if (Utils.isClassUnderPackage(className, "com.alibaba.ttl")) {
                return NO_TRANSFORM;
            }
            if (Utils.isClassUnderPackage(className, "java.lang")) {
                return NO_TRANSFORM;
            }
            ClassInfo classInfo = new ClassInfo(className, classFileBuffer, loader);
            for (JavassistTransformlet transformlet : this.transformletList) {
                transformlet.doTransform(classInfo);
                if (!classInfo.isModified()) continue;
                return classInfo.getCtClass().toBytecode();
            }
        }
        catch (Throwable t) {
            String msg = "Fail to transform class " + classFile + ", cause: " + t.toString();
            logger.log(Level.SEVERE, msg, t);
            throw new IllegalStateException(msg, t);
        }
        return NO_TRANSFORM;
    }

    private static String toClassName(@NonNull String classFile) {
        return classFile.replace('/', '.');
    }
}

