/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.io.InputStream;

public class RecognizeEduPaperOcrRequest
extends Request {
    @Query
    @NameInMap(value="ImageType")
    @Validation(required=true)
    private String imageType;
    @Query
    @NameInMap(value="OutputOricoord")
    private Boolean outputOricoord;
    @Query
    @NameInMap(value="Subject")
    private String subject;
    @Query
    @NameInMap(value="Url")
    @Validation(maxLength=2048)
    private String url;
    @Body
    @NameInMap(value="body")
    private InputStream body;

    private RecognizeEduPaperOcrRequest(Builder builder) {
        super((Request.Builder)builder);
        this.imageType = builder.imageType;
        this.outputOricoord = builder.outputOricoord;
        this.subject = builder.subject;
        this.url = builder.url;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RecognizeEduPaperOcrRequest create() {
        return RecognizeEduPaperOcrRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getImageType() {
        return this.imageType;
    }

    public Boolean getOutputOricoord() {
        return this.outputOricoord;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<RecognizeEduPaperOcrRequest, Builder> {
        private String imageType;
        private Boolean outputOricoord;
        private String subject;
        private String url;
        private InputStream body;

        private Builder() {
        }

        private Builder(RecognizeEduPaperOcrRequest request) {
            super((Request)request);
            this.imageType = request.imageType;
            this.outputOricoord = request.outputOricoord;
            this.subject = request.subject;
            this.url = request.url;
            this.body = request.body;
        }

        public Builder imageType(String imageType) {
            this.putQueryParameter("ImageType", imageType);
            this.imageType = imageType;
            return this;
        }

        public Builder outputOricoord(Boolean outputOricoord) {
            this.putQueryParameter("OutputOricoord", outputOricoord);
            this.outputOricoord = outputOricoord;
            return this;
        }

        public Builder subject(String subject) {
            this.putQueryParameter("Subject", subject);
            this.subject = subject;
            return this;
        }

        public Builder url(String url) {
            this.putQueryParameter("Url", url);
            this.url = url;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public RecognizeEduPaperOcrRequest build() {
            return new RecognizeEduPaperOcrRequest(this);
        }
    }
}

