/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent.mqtt;

import com.aliyun.alink.linksdk.channel.core.base.AError;
import com.aliyun.alink.linksdk.channel.core.base.ARequest;
import com.aliyun.alink.linksdk.channel.core.base.AResponse;
import com.aliyun.alink.linksdk.channel.core.base.IOnCallListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnRrpcResponseHandle;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeRrpcListener;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentConnectState;
import com.aliyun.alink.linksdk.channel.core.persistent.event.PersistentEventDispatcher;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttNet;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttPublishRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttRrpcRequest;
import com.aliyun.alink.utils.LogUtils;
import com.aliyun.alink.utils.TextUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttDefaulCallback
implements MqttCallbackExtended {
    private static final String TAG = "MqttDefaulCallback";
    private Map<String, IOnSubscribeRrpcListener> rrpcListenerMap;
    private Map<String, IOnSubscribeRrpcListener> rrpcPatternListenerMap;

    public void registerRrpcListener(String topic, IOnSubscribeRrpcListener listener) {
        LogUtils.print(TAG, "registerRrpcListener(), topic = " + topic);
        if (TextUtils.isEmpty(topic) || listener == null) {
            LogUtils.print(TAG, "registerRrpcListener(), params error ");
            return;
        }
        if (this.rrpcListenerMap == null) {
            this.rrpcListenerMap = new HashMap<String, IOnSubscribeRrpcListener>();
        }
        if (this.rrpcPatternListenerMap == null) {
            this.rrpcPatternListenerMap = new HashMap<String, IOnSubscribeRrpcListener>();
        }
        if (topic.contains("#") || topic.contains("+")) {
            LogUtils.print(TAG, "registerRrpcListener(), pattern topic ");
            this.rrpcPatternListenerMap.put(topic, listener);
        } else {
            this.rrpcListenerMap.put(topic, listener);
        }
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        LogUtils.print(TAG, "connectComplete," + serverURI);
        MqttNet.getInstance().setConnectState(PersistentConnectState.CONNECTED);
        PersistentEventDispatcher.getInstance().broadcastMessage(1, null, null, null);
        LogUtils.print(TAG, "after connectComplete");
    }

    public void connectionLost(Throwable cause) {
        LogUtils.print(TAG, "connectionLost,cause:" + cause);
        cause.printStackTrace();
        MqttNet.getInstance().setConnectState(PersistentConnectState.DISCONNECTED);
        PersistentEventDispatcher.getInstance().broadcastMessage(2, null, null, null);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        LogUtils.print(TAG, "messageArrived,topic = [" + topic + "] , msg = [" + new String(message.getPayload(), "UTF-8") + "],  ");
        try {
            PersistentEventDispatcher.getInstance().broadcastMessage(3, topic, message.getPayload(), null);
        }
        catch (Exception e) {
            LogUtils.print(TAG, "messageArrived(), send broadcastMsg error");
        }
        if (this.rrpcListenerMap != null && this.rrpcListenerMap.containsKey(topic)) {
            MqttRrpcRequest mqttRrpcRequest = new MqttRrpcRequest();
            mqttRrpcRequest.setTopic(topic);
            mqttRrpcRequest.payloadObj = message.getPayload();
            IOnSubscribeRrpcListener listener = this.rrpcListenerMap.get(topic);
            this.handleRrpcRequest(mqttRrpcRequest, listener);
        } else if (this.rrpcPatternListenerMap != null && this.rrpcPatternListenerMap.size() > 0) {
            for (String topicPattern : this.rrpcPatternListenerMap.keySet()) {
                if (!this.isTopicMatchForPattern(topicPattern, topic)) continue;
                LogUtils.print(TAG, "messageArrived(), match pattern");
                MqttRrpcRequest mqttRrpcRequest = new MqttRrpcRequest();
                mqttRrpcRequest.setTopic(topic);
                mqttRrpcRequest.payloadObj = message.getPayload();
                IOnSubscribeRrpcListener listener = this.rrpcPatternListenerMap.get(topicPattern);
                this.handleRrpcRequest(mqttRrpcRequest, listener);
                break;
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        LogUtils.print(TAG, "deliveryComplete! " + (token == null || token.getResponse() == null ? "null" : token.getResponse().getKey()));
    }

    private void handleRrpcRequest(final MqttRrpcRequest request, final IOnSubscribeRrpcListener listener) {
        LogUtils.print(TAG, "handleRrpcRequest()");
        if (listener == null || request == null) {
            return;
        }
        if (listener.needUISafety()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listener.onReceived(request.topic, request, new RrpcResponseHandle(request.topic, listener));
                }
            });
        } else {
            listener.onReceived(request.topic, request, new RrpcResponseHandle(request.topic, listener));
        }
    }

    private boolean isTopicMatchForPattern(String topicPattern, String topic) {
        if (TextUtils.isEmpty(topicPattern) || TextUtils.isEmpty(topic)) {
            return false;
        }
        try {
            String prefixTopic;
            if (topicPattern.contains("#") && topic.startsWith(prefixTopic = topicPattern.split("#")[0])) {
                return true;
            }
            if (topicPattern.contains("+")) {
                prefixTopic = topicPattern.split("\\+")[0];
                String endTopic = topicPattern.split("\\+", 2)[1];
                if (topic.startsWith(prefixTopic) && topic.endsWith(endTopic)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LogUtils.print(TAG, "isTopicMatchForPattern(),e = " + e.toString());
        }
        return false;
    }

    private class RrpcResponseHandle
    implements IOnRrpcResponseHandle {
        private String topic;
        private IOnSubscribeRrpcListener listener;

        public RrpcResponseHandle(String topic, IOnSubscribeRrpcListener listener) {
            this.topic = topic;
            this.listener = listener;
        }

        @Override
        public void onRrpcResponse(String replyTopic, AResponse response) {
            LogUtils.print(MqttDefaulCallback.TAG, "onRrpcResponse(), reply topic = " + replyTopic);
            MqttPublishRequest publishRequest = new MqttPublishRequest();
            publishRequest.isRPC = false;
            publishRequest.topic = TextUtils.isEmpty(replyTopic) ? this.topic + "_reply" : replyTopic;
            if (response != null && response.data != null) {
                publishRequest.payloadObj = response.data;
            }
            MqttNet.getInstance().asyncSend(publishRequest, new IOnCallListener(){

                @Override
                public void onSuccess(ARequest request, AResponse response) {
                    LogUtils.print(MqttDefaulCallback.TAG, "onRrpcResponse(), publish succ");
                    RrpcResponseHandle.this.listener.onResponseSuccess(RrpcResponseHandle.this.topic);
                }

                @Override
                public void onFailed(ARequest request, AError error) {
                    LogUtils.print(MqttDefaulCallback.TAG, "onRrpcResponse(), publish fail");
                    RrpcResponseHandle.this.listener.onResponseFailed(RrpcResponseHandle.this.topic, error);
                }

                @Override
                public boolean needUISafety() {
                    return RrpcResponseHandle.this.listener.needUISafety();
                }
            });
        }
    }
}

