/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent.mqtt;

import com.aliyun.alink.linksdk.channel.core.base.AError;
import com.aliyun.alink.linksdk.channel.core.base.ARequest;
import com.aliyun.alink.linksdk.channel.core.base.ASend;
import com.aliyun.alink.linksdk.channel.core.base.IOnCallListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeRrpcListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IPersisitentNet;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentConnectState;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentInitParams;
import com.aliyun.alink.linksdk.channel.core.persistent.event.PersistentEventDispatcher;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttConfigure;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttDefaulCallback;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttInitParams;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttSubscribeRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send.MqttSend;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send.MqttSendExecutor;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.utils.MqttTrustManager;
import com.aliyun.alink.utils.LogUtils;
import com.aliyun.alink.utils.TextUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttNet
implements IPersisitentNet {
    private static final String TAG = "MqttNet";
    private MemoryPersistence persistence;
    private MqttAsyncClient mqttAsyncClient;
    private SSLSocketFactory socketFactory;
    private MqttConnectOptions connOpts;
    private InputStream mqttRootCrtFile;
    private boolean isInitConnect = false;
    private PersistentConnectState connectState = PersistentConnectState.DISCONNECTED;
    private MqttDefaulCallback defaulCallback = null;
    private MqttInitParams mqttInitParams;

    public static MqttNet getInstance() {
        return InstanceHolder.sInstance;
    }

    @Override
    public void init(PersistentInitParams initParams) {
        LogUtils.print(TAG, "init()");
        if (this.isInitConnect || this.connectState == PersistentConnectState.CONNECTING || this.connectState == PersistentConnectState.CONNECTED) {
            LogUtils.print(TAG, "init(), already init, ignore init call!");
            return;
        }
        if (initParams == null || !(initParams instanceof MqttInitParams) || !((MqttInitParams)initParams).checkValid()) {
            LogUtils.error(TAG, "init error ,params error");
            return;
        }
        this.mqttInitParams = (MqttInitParams)initParams;
        MqttConfigure.productKey = this.mqttInitParams.productKey;
        MqttConfigure.deviceName = this.mqttInitParams.deviceName;
        MqttConfigure.deviceSecret = this.mqttInitParams.deviceSecret;
        boolean bl = MqttConfigure.cleanSession = !this.mqttInitParams.receiveOfflineMsg;
        if (MqttConfigure.mqttRootCrtFile == null) {
            LogUtils.print(TAG, "init(),default cert file");
            try {
                this.mqttRootCrtFile = MqttNet.class.getResourceAsStream("/root.crt");
            }
            catch (Exception e) {
                LogUtils.error(TAG, "setCertFile : cannot config cert file\uff1a" + e.getMessage());
            }
        } else {
            LogUtils.print(TAG, "init(),custom cert file");
            this.mqttRootCrtFile = MqttConfigure.mqttRootCrtFile;
        }
        this.mqttClientConnect();
    }

    @Override
    public void destroy() {
        LogUtils.print(TAG, "destroy()");
        this.isInitConnect = false;
        if (this.getClient() == null) {
            LogUtils.print(TAG, "destroy(), client is null");
            return;
        }
        try {
            this.mqttAsyncClient.disconnect();
            LogUtils.print(TAG, "destroy(),disconnect");
            this.connectState = PersistentConnectState.DISCONNECTED;
            PersistentEventDispatcher.getInstance().broadcastMessage(2, null, null, "disconnect success");
            this.persistence.close();
            this.persistence = null;
            this.mqttAsyncClient = null;
            this.socketFactory = null;
            this.mqttRootCrtFile.close();
            this.mqttRootCrtFile = null;
            this.mqttInitParams = null;
        }
        catch (Exception e) {
            LogUtils.print(TAG, "distroy(), error, e = " + e.toString());
            e.printStackTrace();
        }
    }

    public PersistentInitParams getInitParams() {
        return this.mqttInitParams;
    }

    public void setConnectState(PersistentConnectState connectState) {
        this.connectState = connectState;
    }

    @Override
    public PersistentConnectState getConnectState() {
        return this.connectState;
    }

    @Override
    public ASend asyncSend(ARequest request, IOnCallListener listener) {
        MqttSend mqttSend = new MqttSend(request, listener);
        MqttSendExecutor sendExecutor = new MqttSendExecutor();
        sendExecutor.asyncSend(mqttSend);
        return mqttSend;
    }

    @Override
    public void retry(ASend connect) {
        MqttSendExecutor sendExecutor = new MqttSendExecutor();
        sendExecutor.asyncSend(connect);
    }

    @Override
    public void subscribe(String topic, IOnSubscribeListener listener) {
        if (TextUtils.isEmpty(topic)) {
            LogUtils.print(TAG, "subscribe, topic is empty");
            return;
        }
        MqttSubscribeRequest subscribeRequest = new MqttSubscribeRequest();
        subscribeRequest.topic = topic;
        subscribeRequest.isSubscribe = true;
        MqttSend mqttSend = new MqttSend((ARequest)subscribeRequest, listener);
        MqttSendExecutor sendExecutor = new MqttSendExecutor();
        sendExecutor.asyncSend(mqttSend);
    }

    @Override
    public void unSubscribe(String topic, IOnSubscribeListener listener) {
        if (TextUtils.isEmpty(topic)) {
            LogUtils.print(TAG, "unSubscribe, topic is empty");
            return;
        }
        MqttSubscribeRequest subscribeRequest = new MqttSubscribeRequest();
        subscribeRequest.topic = topic;
        subscribeRequest.isSubscribe = false;
        MqttSend mqttSend = new MqttSend((ARequest)subscribeRequest, listener);
        MqttSendExecutor sendExecutor = new MqttSendExecutor();
        sendExecutor.asyncSend(mqttSend);
    }

    @Override
    public void subscribeRrpc(String topic, final IOnSubscribeRrpcListener listener) {
        LogUtils.print(TAG, "subscribeRrpc(),topic = " + topic);
        if (TextUtils.isEmpty(topic) || listener == null) {
            LogUtils.print(TAG, "subscribeRrpc(), params error");
            return;
        }
        this.subscribe(topic, new IOnSubscribeListener(){

            @Override
            public void onSuccess(String topic) {
                listener.onSubscribeSuccess(topic);
            }

            @Override
            public void onFailed(String topic, AError error) {
                listener.onSubscribeFailed(topic, error);
            }

            @Override
            public boolean needUISafety() {
                return listener.needUISafety();
            }
        });
        if (this.defaulCallback != null) {
            LogUtils.print(TAG, "subscribeRrpc(), registerRrpcListener");
            this.defaulCallback.registerRrpcListener(topic, listener);
        }
    }

    public IMqttAsyncClient getClient() {
        return this.mqttAsyncClient;
    }

    private void mqttClientConnect() {
        this.persistence = new MemoryPersistence();
        String timestamp = System.currentTimeMillis() + "";
        String serverURI = MqttConfigure.mqttHost;
        if (TextUtils.isEmpty(MqttConfigure.mqttHost)) {
            serverURI = "ssl://" + MqttConfigure.productKey + ".iot-as-mqtt.cn-shanghai.aliyuncs.com:1883";
        } else if (!MqttConfigure.mqttHost.startsWith("ssl://")) {
            serverURI = "ssl://" + serverURI;
        }
        String clientId = MqttConfigure.deviceName + "&" + MqttConfigure.productKey;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("productKey", MqttConfigure.productKey);
        params.put("deviceName", MqttConfigure.deviceName);
        params.put("clientId", clientId);
        params.put("timestamp", timestamp);
        String mqttClientId = clientId + "|securemode=" + 2 + ",signmethod=" + "hmacsha1" + ",ext=1" + ",timestamp=" + timestamp + "|";
        String mqttUsername = MqttConfigure.deviceName + "&" + MqttConfigure.productKey;
        String mqttPassword = this.hmacSign(params, MqttConfigure.deviceSecret);
        try {
            this.mqttAsyncClient = new MqttAsyncClient(serverURI, mqttClientId, (MqttClientPersistence)this.persistence);
        }
        catch (Exception e) {
            LogUtils.error(TAG, "create mqtt client error,e" + e.toString());
            e.printStackTrace();
            this.connectState = PersistentConnectState.CONNECTFAIL;
            PersistentEventDispatcher.getInstance().broadcastMessage(7, null, null, "create mqtt client error,e" + e.toString());
            return;
        }
        this.connOpts = new MqttConnectOptions();
        this.connOpts.setMqttVersion(4);
        this.connOpts.setMaxInflight(30);
        if (MqttConfigure.isCheckRootCrt) {
            try {
                this.socketFactory = this.createSSLSocket();
                this.connOpts.setSocketFactory((SocketFactory)this.socketFactory);
            }
            catch (Exception e) {
                LogUtils.error(TAG, "create SSL Socket error" + e.toString());
                e.printStackTrace();
            }
        }
        this.connOpts.setAutomaticReconnect(true);
        this.connOpts.setCleanSession(MqttConfigure.cleanSession);
        this.connOpts.setUserName(mqttUsername);
        this.connOpts.setPassword(mqttPassword.toCharArray());
        this.connOpts.setKeepAliveInterval(MqttConfigure.getKeepAliveInterval());
        this.defaulCallback = new MqttDefaulCallback();
        this.mqttAsyncClient.setCallback((MqttCallback)this.defaulCallback);
        try {
            this.connectState = PersistentConnectState.CONNECTING;
            this.mqttAsyncClient.connect(this.connOpts, null, new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    LogUtils.print(MqttNet.TAG, "connect onSuccess");
                    MqttNet.this.isInitConnect = true;
                    MqttNet.this.connectState = PersistentConnectState.CONNECTED;
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    LogUtils.print(MqttNet.TAG, "connect onFailure, exce = " + exception.toString());
                    MqttNet.this.connectState = PersistentConnectState.CONNECTFAIL;
                    PersistentEventDispatcher.getInstance().broadcastMessage(7, null, null, exception.toString());
                }
            });
            LogUtils.print(TAG, "mqtt client connect..," + serverURI);
        }
        catch (Exception e) {
            LogUtils.error(TAG, " mqtt client connect error,e" + e.toString());
            e.printStackTrace();
            this.connectState = PersistentConnectState.CONNECTFAIL;
            PersistentEventDispatcher.getInstance().broadcastMessage(7, null, null, e.toString());
        }
    }

    private SSLSocketFactory createSSLSocket() throws Exception {
        SSLContext context = SSLContext.getInstance("TLSV1.2");
        context.init(null, new TrustManager[]{new MqttTrustManager(this.mqttRootCrtFile)}, null);
        SSLSocketFactory socketFactory = context.getSocketFactory();
        return socketFactory;
    }

    private String hmacSign(Map<String, String> params, String secret) {
        if (params == null || TextUtils.isEmpty(secret)) {
            return null;
        }
        Object[] sortedKeys = params.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Object key : sortedKeys) {
            if ("sign".equalsIgnoreCase((String)key)) continue;
            canonicalizedQueryString.append((String)key).append(params.get(key));
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("utf-8"), "hmacsha1");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            byte[] data = mac.doFinal(canonicalizedQueryString.toString().getBytes("utf-8"));
            return MqttNet.bytesToHexString(data);
        }
        catch (Exception e) {
            LogUtils.error(TAG, "hmacSign error, e" + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    private static class InstanceHolder {
        private static final MqttNet sInstance = new MqttNet();

        private InstanceHolder() {
        }
    }
}

