/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send;

import com.aliyun.alink.linksdk.channel.core.base.AError;
import com.aliyun.alink.linksdk.channel.core.base.ARequest;
import com.aliyun.alink.linksdk.channel.core.base.AResponse;
import com.aliyun.alink.linksdk.channel.core.base.ASend;
import com.aliyun.alink.linksdk.channel.core.base.IOnCallListener;
import com.aliyun.alink.linksdk.channel.core.persistent.BadNetworkException;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeListener;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttPublishRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttSubscribeRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send.MqttSendExecutor;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send.MqttSendStatus;
import com.aliyun.alink.utils.LogUtils;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttSend
extends ASend
implements IMqttActionListener {
    private static final String TAG = "MqttSend";
    private IOnSubscribeListener subscribeListener = null;

    public MqttSend(ARequest request, IOnCallListener listener) {
        super(request, listener);
        this.setStatus(MqttSendStatus.waitingToSend);
    }

    public MqttSend(ARequest request, IOnSubscribeListener listener) {
        super(request, null);
        this.subscribeListener = listener;
        this.setStatus(MqttSendStatus.waitingToSend);
    }

    public void setStatus(MqttSendStatus state) {
        this.status = state;
    }

    @Override
    public MqttSendStatus getStatus() {
        return (MqttSendStatus)this.status;
    }

    public IOnSubscribeListener getSubscribeListener() {
        return this.subscribeListener;
    }

    public void onSuccess(IMqttToken asyncActionToken) {
        if (this.request instanceof MqttSubscribeRequest) {
            this.setStatus(MqttSendStatus.completed);
            boolean isSucc = true;
            try {
                int qos = asyncActionToken.getGrantedQos()[0];
                if (qos == 128) {
                    isSucc = false;
                }
            }
            catch (Exception e) {
                LogUtils.print(TAG, "onSuccess(),getGrantedQos");
            }
            if (this.subscribeListener != null) {
                if (isSucc) {
                    this.subscribeListener.onSuccess(((MqttSubscribeRequest)this.request).topic);
                } else {
                    AError error = new AError();
                    error.setCode(4103);
                    error.setMsg("subACK Failure");
                    this.subscribeListener.onFailed(((MqttSubscribeRequest)this.request).topic, error);
                }
            }
        } else if (this.request instanceof MqttPublishRequest) {
            MqttPublishRequest publishRequest = (MqttPublishRequest)this.request;
            if (!publishRequest.isRPC) {
                this.setStatus(MqttSendStatus.completed);
                if (this.listener != null) {
                    this.listener.onSuccess(this.request, this.response);
                }
            } else if (this.status == MqttSendStatus.waitingToSubReply) {
                this.setStatus(MqttSendStatus.subReplyed);
                MqttSendExecutor sendExecutor = new MqttSendExecutor();
                sendExecutor.asyncSend(this);
            } else if (this.status == MqttSendStatus.waitingToPublish) {
                this.setStatus(MqttSendStatus.published);
            }
        }
    }

    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
        String msg = null != exception ? exception.getMessage() : "MqttNet send failed: unknown error";
        this.setStatus(MqttSendStatus.completed);
        if (this.request instanceof MqttSubscribeRequest) {
            if (this.subscribeListener != null) {
                int type = 5;
                if (exception instanceof BadNetworkException) {
                    type = 6;
                }
                if (type == 6) {
                    AError error = new AError();
                    error.setCode(4101);
                    this.subscribeListener.onFailed(((MqttSubscribeRequest)this.request).topic, error);
                } else {
                    AError error = new AError();
                    error.setCode(4201);
                    error.setMsg(msg);
                    this.subscribeListener.onFailed(((MqttSubscribeRequest)this.request).topic, error);
                }
            }
        } else if (this.request instanceof MqttPublishRequest && this.listener != null) {
            int type = 2;
            if (exception instanceof BadNetworkException) {
                type = 3;
            }
            if (type == 3) {
                AError error = new AError();
                error.setCode(4101);
                this.listener.onFailed(this.request, error);
            } else {
                AError error = new AError();
                error.setCode(4201);
                error.setMsg(msg);
                this.listener.onFailed(this.request, error);
            }
        }
    }

    public void rpcMessageArrived(String topic, MqttMessage message) {
        LogUtils.print(TAG, "messageArrived(), topic =" + topic + " msg =" + message.toString());
        if (this.request instanceof MqttPublishRequest) {
            MqttPublishRequest publishRequest = (MqttPublishRequest)this.request;
            if (publishRequest.isRPC && (this.status == MqttSendStatus.published || this.status == MqttSendStatus.waitingToPublish) && topic.equals(publishRequest.replyTopic)) {
                LogUtils.print(TAG, "messageArrived(), match!");
                this.setStatus(MqttSendStatus.completed);
                if (null == this.response) {
                    this.response = new AResponse();
                }
                this.response.data = message.toString();
                if (this.listener != null) {
                    this.listener.onSuccess(this.request, this.response);
                }
            }
        }
    }
}

