/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient;

import com.taobao.drc.clusterclient.util.Gaugeable;
import com.taobao.drc.clusterclient.util.Time;
import java.util.Map;
import java.util.TreeMap;

public class NotifyController<R>
implements Gaugeable {
    private static final String KEY_NOTIFIED_MESSAGE_SIZE = "notified.size";
    private static final String KEY_NOTIFIED_MESSAGE_SAMPLE_PERIOD_MS = "notified.sample_period_ms";
    private static final String KEY_NOTIFIED_MESSAGE_RPS = "notified.rps";
    private final Time time;
    private volatile long expirationMs = 0L;
    private volatile boolean closed = false;
    private volatile long lastNotifiedMs = 0L;
    private volatile long notifiedCounter = 0L;
    private volatile long lastSampleCounter = 0L;
    private volatile long lastSampleMs = 0L;
    private volatile boolean notifying = false;

    public NotifyController(Time time) {
        this.time = time;
    }

    public boolean isNotifying() {
        return this.notifying;
    }

    public void setNotifying(boolean notifying) {
        this.notifying = notifying;
    }

    public void onNotified(R message) {
        this.lastNotifiedMs = this.time.millis();
        ++this.notifiedCounter;
    }

    public long getLastNotifiedMs() {
        return this.lastNotifiedMs;
    }

    public boolean isValid() {
        return !this.isClosed() && this.time.millis() < this.expirationMs;
    }

    public void extendLeaseTo(long targetMs) {
        this.expirationMs = targetMs;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    @Override
    public Map<String, Object> getMetrics() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        long now = this.time.millis();
        long sampleCounter = this.notifiedCounter;
        if (this.lastSampleMs > 0L) {
            long periodMs = now - this.lastSampleMs;
            long msgNum = sampleCounter - this.lastSampleCounter;
            if (periodMs > 0L) {
                map.put(KEY_NOTIFIED_MESSAGE_SAMPLE_PERIOD_MS, periodMs);
                map.put(KEY_NOTIFIED_MESSAGE_RPS, msgNum * 1000L / periodMs);
            }
            this.lastSampleMs = now;
            this.lastSampleCounter = sampleCounter;
        }
        map.put(KEY_NOTIFIED_MESSAGE_SIZE, this.notifiedCounter);
        return map;
    }
}

