/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.clustermanager;

import java.util.HashMap;
import java.util.Map;

public class PartitionInfo {
    private String guid;
    private String group;
    private String partition;
    private String topic;
    private Map<String, TableDetail> tables;
    private Integer partitionId;
    private Integer partitionNum;
    private Integer errCode;
    private String errMsg;

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Map<String, TableDetail> getTables() {
        return this.tables;
    }

    public void setTables(Map<String, TableDetail> tables) {
        this.tables = tables;
    }

    public Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String makeFilterString() {
        if (this.getTables() == null || this.getTables().isEmpty()) {
            throw new IllegalStateException("Partition [" + this.partition + "] has no tables?");
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, TableDetail> entry : this.getTables().entrySet()) {
            String dbName = entry.getKey();
            for (String tableName : entry.getValue().getTables().keySet()) {
                if (builder.length() > 0) {
                    builder.append("|");
                }
                builder.append(dbName).append(".").append(tableName).append(".*");
            }
        }
        return builder.toString();
    }

    public String toString() {
        return "PartitionInfo{guid='" + this.guid + '\'' + ", group='" + this.group + '\'' + ", partition='" + this.partition + '\'' + ", topic='" + this.topic + '\'' + ", tables=" + this.tables + ", partitionId=" + this.partitionId + ", partitionNum=" + this.partitionNum + ", errCode=" + this.errCode + ", errMsg='" + this.errMsg + '\'' + '}';
    }

    public static class TableDetail {
        private String name;
        private Map<String, String> tables = new HashMap<String, String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getTables() {
            return this.tables;
        }

        public void setTables(Map<String, String> tables) {
            this.tables = tables;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableDetail that = (TableDetail)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.tables != null ? this.tables.equals(that.tables) : that.tables == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
            return result;
        }
    }
}

