/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.httpclient;

import com.alibaba.fastjson.JSON;
import com.taobao.drc.clusterclient.httpclient.HttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final String DEFAULT_API_VERSION = "1.0";
    private static final String KEY_API_VERSION = "X-API-Version";
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private static final String DefaultEncoding = "UTF-8";
    private static final int DefaultConnectionTimeout = 60000;
    private static final int DefaultSocketTimeout = 60000;
    private static final int DefaultMaxPerRoute = 500;
    private static final RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).build();
    private static final org.apache.http.client.HttpClient client;

    public HttpResponse get(String path) throws IOException {
        HttpGet method = new HttpGet(path);
        method.setConfig(defaultRequestConfig);
        org.apache.http.HttpResponse response = client.execute((HttpUriRequest)method);
        HttpResponse resp = new HttpResponse(response);
        method.releaseConnection();
        if (resp.getCode() != 200) {
            throw new IllegalStateException("Register to " + path + " failed: " + resp);
        }
        return resp;
    }

    public HttpResponse post(String url, HttpEntity entity, String apiVersion, RequestConfig requestConfig) throws IOException {
        HttpPost method = new HttpPost(url);
        method.addHeader(KEY_API_VERSION, apiVersion);
        method.setEntity(entity);
        method.setConfig(requestConfig);
        HttpResponse resp = new HttpResponse(client.execute((HttpUriRequest)method));
        method.releaseConnection();
        if (resp.getCode() != 200) {
            throw new IllegalStateException("Post to [" + url + "] with [" + EntityUtils.toString((HttpEntity)entity) + "] failed: [" + resp + "]");
        }
        return resp;
    }

    public HttpResponse post(String url, Map<String, String> posts) throws IllegalStateException, IOException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> pair : posts.entrySet()) {
            parameters.add(new BasicNameValuePair(pair.getKey(), pair.getValue()));
        }
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(parameters, DefaultEncoding), DEFAULT_API_VERSION, defaultRequestConfig);
    }

    public <R> R post(String url, String data, Class<R> responseClass, String apiVersion, RequestConfig requestConfig) throws IOException {
        HttpResponse response = this.post(url, (HttpEntity)new StringEntity(data, ContentType.APPLICATION_JSON), apiVersion, requestConfig);
        return (R)JSON.parseObject((String)response.getString(), responseClass);
    }

    static {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(500);
        manager.setDefaultMaxPerRoute(500);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }
}

