/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.impl;

import com.taobao.drc.clusterclient.clustermanager.PartitionInfo;
import com.taobao.drc.clusterclient.partition.BaseCheckpoint;
import com.taobao.drc.clusterclient.partition.CheckpointManager;
import com.taobao.drc.clusterclient.partition.IPartition;
import java.util.Map;
import java.util.TreeMap;

public class DefaultPartitionImpl<C extends BaseCheckpoint>
implements IPartition<C> {
    public static final String KEY_PARTITION_HEARTBEAT_TIME_IN_SEC = "partition.heartbeat-sec";
    private final String name;
    private final String guid;
    private final String group;
    private final String topic;
    private final Integer partitionId;
    private final Integer partitionNum;
    private final CheckpointManager checkpointManager;
    private volatile long heartbeatTimeInSec = 0L;

    public DefaultPartitionImpl(PartitionInfo partitionInfo, Integer bufSize) {
        this(partitionInfo.getPartition(), partitionInfo.getGuid(), partitionInfo.getGroup(), partitionInfo.getTopic(), partitionInfo.getPartitionId(), partitionInfo.getPartitionNum(), bufSize);
    }

    public DefaultPartitionImpl(String name, String guid, String group, String topic, int partitionId, Integer partitionNum, Integer bufSize) {
        this.name = name;
        this.guid = guid;
        this.group = group;
        this.topic = topic;
        this.partitionId = partitionId;
        this.partitionNum = partitionNum;
        this.checkpointManager = new CheckpointManager(bufSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Integer getPartitionId() {
        return this.partitionId;
    }

    @Override
    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public void bookCheckpoint(C checkpoint) throws InterruptedException {
        this.checkpointManager.book((BaseCheckpoint)checkpoint);
    }

    @Override
    public void ackAsConsumed(C checkpoint) {
        this.checkpointManager.ack((BaseCheckpoint)checkpoint);
    }

    @Override
    public C getCheckpoint() {
        return (C)this.checkpointManager.getFirstNotAckedOrLatestCheckpoint();
    }

    public void setHeartbeatTimeInSec(long heartbeatTimeInSec) {
        this.heartbeatTimeInSec = heartbeatTimeInSec;
    }

    @Override
    public long getHeartbeatTimeInSec() {
        return this.heartbeatTimeInSec;
    }

    @Override
    public Map<String, Object> getMetrics() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(this.checkpointManager.getMetrics());
        map.put(KEY_PARTITION_HEARTBEAT_TIME_IN_SEC, this.getHeartbeatTimeInSec());
        return map;
    }

    @Override
    public Iterable<BaseCheckpoint> getCheckpoints() {
        return this.checkpointManager;
    }
}

