/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.partition;

import com.taobao.drc.clusterclient.partition.IPartition;
import org.apache.commons.lang3.StringUtils;

public class BaseCheckpoint {
    private static final int FIELD_NUM = 6;
    private static final int IP = 0;
    private static final int PORT = 1;
    private static final int FILE = 2;
    private static final int OFFSET = 3;
    private static final int TMSP = 4;
    private static final int MSG_ID = 5;
    private final String[] list;
    private final IPartition partition;
    private BaseCheckpoint prev;
    private BaseCheckpoint next;
    private boolean acked = false;

    public BaseCheckpoint(IPartition partition) {
        this.list = new String[6];
        this.partition = partition;
    }

    public BaseCheckpoint(String checkpoint, IPartition partition) {
        this.list = this.parseCheckpoint(checkpoint);
        this.partition = partition;
    }

    private String[] parseCheckpoint(String checkpoint) {
        String[] segs = checkpoint.split(":");
        if (segs.length != 6) {
            throw new IllegalArgumentException("Invalid checkpoint [" + checkpoint + "]");
        }
        String[] ret = new String[6];
        for (int i = 0; i < segs.length; ++i) {
            if (segs[i] == null || segs[i].isEmpty()) continue;
            ret[i] = segs[i];
        }
        return ret;
    }

    public final String getIp() {
        return this.list[0];
    }

    public final String getPort() {
        return this.list[1];
    }

    public final String getInstance() {
        if (this.list[0] != null && this.list[1] != null) {
            return this.list[0] + "-" + this.list[1];
        }
        return null;
    }

    public void setInstance(String instance) {
        String[] ins = StringUtils.split((String)instance, (char)'-');
        this.list[0] = ins[0];
        this.list[1] = ins[1];
    }

    public final String getFile() {
        return this.list[2];
    }

    public final String getFileOffset() {
        return this.list[3];
    }

    public void setFilePosition(String pos) {
        String[] fileposition = StringUtils.split((String)pos, (char)'@');
        this.list[2] = fileposition[1];
        this.list[3] = fileposition[0];
    }

    public final String getFilePosition() {
        if (this.list[3] != null && this.list[2] != null) {
            return this.list[3] + "@" + this.list[2];
        }
        return null;
    }

    public final String getTimestamp() {
        return this.list[4];
    }

    public void setTimestamp(String timestamp) {
        this.list[4] = timestamp;
    }

    public final String getId() {
        return this.list[5];
    }

    public void setId(String id) {
        this.list[5] = id;
    }

    public void ackAsConsumed() {
        if (this.partition != null) {
            this.partition.ackAsConsumed(this);
        }
    }

    BaseCheckpoint getPrev() {
        return this.prev;
    }

    void setPrev(BaseCheckpoint prev) {
        this.prev = prev;
    }

    BaseCheckpoint getNext() {
        return this.next;
    }

    void setNext(BaseCheckpoint next) {
        this.next = next;
    }

    boolean isAcked() {
        return this.acked;
    }

    void ack() {
        this.acked = true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.list.length; ++i) {
            builder.append(this.list[i]);
            if (i == this.list.length - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }
}

