/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetworkUtils.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canAddressBeUsed(NetworkInterface networkInterface, InetAddress address) {
        if (address instanceof Inet4Address) {
            if (address.isLoopbackAddress()) {
                logger.info("Ignore loop back address [{}]", (Object)address.getHostAddress());
                return false;
            } else if (address.isMulticastAddress()) {
                logger.info("Ignore multi-cast address [{}]", (Object)address.getHostAddress());
                return false;
            } else {
                if (!address.isLinkLocalAddress()) return true;
                logger.info("Ignore link local address [{}]", (Object)address.getHostAddress());
            }
            return false;
        } else {
            logger.info("Ignore non-inet4 address [{}]", (Object)address.getHostAddress());
        }
        return false;
    }

    public static String getLocalIp() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> ips = new ArrayList<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!NetworkUtils.canAddressBeUsed(networkInterface, address)) continue;
                ips.add(address.getHostAddress());
            }
        }
        if (ips.size() == 1) {
            logger.info("Found exactly one ip [{}]", ips.get(0));
            return (String)ips.get(0);
        }
        logger.info("Found multiple ips {}, use the one from localhost", ips);
        return InetAddress.getLocalHost().getHostAddress();
    }
}

