/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SettableFuture<V>
implements Future<V> {
    private final Lock lock = new ReentrantLock();
    private final Condition finished = this.lock.newCondition();
    private V value;
    private Throwable throwable;
    private boolean done = false;

    public void success(V value) {
        this.lock.lock();
        try {
            if (this.isDone()) {
                throw new IllegalStateException("The future has already been fulfilled");
            }
            this.value = value;
            this.done = true;
            this.finished.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void failure(Throwable throwable) {
        this.lock.lock();
        try {
            if (this.isDone()) {
                throw new IllegalStateException("The future has already been fulfilled");
            }
            this.throwable = throwable != null ? throwable : new IllegalArgumentException("Future was fulfilled with a null failure");
            this.done = true;
            this.finished.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (throwable == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.done) {
                this.finished.await();
            }
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long remainingNs = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long dueNs = System.nanoTime() + remainingNs;
        this.lock.lock();
        try {
            while (!this.done) {
                if (remainingNs < 0L) {
                    throw new TimeoutException();
                }
                this.finished.await(remainingNs, TimeUnit.NANOSECONDS);
                remainingNs = dueNs - System.nanoTime();
            }
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

