/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local;

import com.aliyun.odps.Column;
import com.aliyun.odps.graph.local.utils.LocalGraphRunUtils;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableRecord;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SQLRecord
implements WritableRecord {
    private Column[] cols;
    private Map<String, Integer> mapIdx;
    private byte[] types;
    private Writable[] fields;

    public SQLRecord(Column[] columns, byte[] types) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        this.cols = columns;
        this.types = types;
        this.mapIdx = new HashMap<String, Integer>();
        this.fields = new Writable[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.mapIdx.put(columns[i].getName(), i);
        }
    }

    public SQLRecord(Column[] columns) {
        this(columns, null);
    }

    public int size() {
        return this.cols.length;
    }

    public boolean isNull(int idx) {
        return this.fields[idx] == null || this.fields[idx] instanceof NullWritable;
    }

    public boolean isNull(String fieldName) throws IOException {
        Integer idx = this.mapIdx.get(fieldName);
        if (idx == null) {
            throw new IOException("Invalid field name: " + fieldName);
        }
        return this.isNull(idx);
    }

    public Writable get(int idx) {
        return this.fields[idx];
    }

    public Writable get(String fieldName) throws IOException {
        Integer idx = this.mapIdx.get(fieldName);
        if (idx == null) {
            throw new IOException("Invalid field name: " + fieldName);
        }
        return this.fields[idx];
    }

    public void set(int idx, Writable value) {
        this.checkColIndex(idx);
        this.fields[idx] = value;
    }

    public void set(String fieldName, Writable value) throws IOException {
        Integer idx = this.mapIdx.get(fieldName);
        if (idx == null) {
            throw new IOException("Invalid field name: " + fieldName);
        }
        this.set(idx, value);
    }

    public void set(Writable[] values) throws IOException {
        if (this.cols.length != values.length) {
            throw new IOException("Size unmatch: " + values.length + ", expect: " + this.cols.length);
        }
        for (int idx = 0; idx < this.cols.length; ++idx) {
            this.fields[idx] = values[idx];
        }
    }

    public Column getField(int index) {
        return this.cols[index];
    }

    public Column[] getFields() {
        return this.cols;
    }

    public Writable[] getAll() {
        return this.fields;
    }

    public String toString() {
        return "SQLRecord [cols=" + Arrays.toString(this.cols) + ", fields=" + Arrays.toString(this.fields) + "]";
    }

    Writable[] getInternalValues() {
        return this.fields;
    }

    private void checkColIndex(int index) {
        if (index >= this.size() || index < 0) {
            throw new RuntimeException("ODPS-0730001: Column index out of bound - col index '" + index + "' must be in range [0, " + (this.size() - 1) + "]");
        }
    }

    public SQLRecord clone() {
        SQLRecord rec = new SQLRecord(this.cols, this.types);
        rec.fields = LocalGraphRunUtils.createFileds(this.types);
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] != null) {
                if (this.fields[i] instanceof NullWritable) {
                    rec.fields[i] = NullWritable.get();
                    continue;
                }
                try {
                    ReflectionUtils.cloneWritableInto((Writable)rec.fields[i], (Writable)this.fields[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            rec.fields[i] = null;
        }
        return rec;
    }
}

