/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local.utils;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.graph.Aggregator;
import com.aliyun.odps.graph.DefaultLoadingVertexResolver;
import com.aliyun.odps.graph.JobConf;
import com.aliyun.odps.graph.Partitioner;
import com.aliyun.odps.graph.VertexResolver;
import com.aliyun.odps.graph.local.HashPartitioner;
import com.aliyun.odps.io.BooleanWritable;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.DoubleWritable;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.utils.CommonUtils;
import com.aliyun.odps.utils.ReflectionUtils;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalGraphRunUtils {
    private static final Log LOG = LogFactory.getLog(LocalGraphRunUtils.class);
    private static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String generateGraphTaskName() {
        return "console_graph_" + LocalRunUtils.getDateFormat((String)"yyyyMMddHHmmss_SSS").format(new Date());
    }

    public static String generateLocalGraphTaskName() {
        return "graph_" + LocalRunUtils.getDateFormat((String)"yyyyMMddHHmmss_SSS").format(new Date()) + "_" + LocalRunUtils.getPID();
    }

    public static int getMaxGraphTasks() {
        String s = System.getProperty("odps.graph.local.max.workers");
        int maxGraphWorkers = 0;
        if (!StringUtils.isEmpty((String)s)) {
            maxGraphWorkers = Integer.parseInt(s);
            CommonUtils.checkArgument((String)"max graph workers", (int)maxGraphWorkers, (int)0, (int)100);
        }
        return 100;
    }

    public static Partitioner createPartitioner(JobConf conf) throws IOException {
        Partitioner p = null;
        Class partitionClass = conf.getPartitionerClass();
        p = partitionClass != null ? (Partitioner)ReflectionUtils.newInstance((Class)partitionClass, (Configuration)conf) : new HashPartitioner();
        p.configure((Configuration)conf);
        return p;
    }

    public static List<Aggregator> getAggregator(JobConf conf) {
        String classes = conf.get("odps.graph.aggregator.classes");
        try {
            ArrayList<Aggregator> ret = new ArrayList<Aggregator>();
            if (classes != null) {
                String[] classNames;
                for (String className : classNames = classes.split(";")) {
                    if (StringUtils.isEmpty((String)className)) continue;
                    Class<?> c = Class.forName(className);
                    Aggregator aggr = (Aggregator)c.newInstance();
                    ret.add(aggr);
                }
            }
            return ret;
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            ArrayList<Aggregator> ret = new ArrayList<Aggregator>();
            return ret;
        }
    }

    public static VertexResolver createLoadingVertexResolver(JobConf conf) throws IOException {
        Class<DefaultLoadingVertexResolver> cls = conf.getLoadingVertexResolverClass();
        if (cls == null) {
            cls = DefaultLoadingVertexResolver.class;
        }
        VertexResolver resolver = (VertexResolver)ReflectionUtils.newInstance(cls, (Configuration)conf);
        resolver.configure((Configuration)conf);
        return resolver;
    }

    public static VertexResolver createSuperstepVertexResolver(JobConf conf) throws IOException {
        Class cls = conf.getComputingVertexResolverClass();
        if (cls == null) {
            return null;
        }
        VertexResolver resolver = (VertexResolver)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        resolver.configure((Configuration)conf);
        return resolver;
    }

    public static JobConf getGraphJobConf(JobConf conf) {
        return new JobConf((Configuration)conf);
    }

    public static JobConf getJobConf(JobConf conf) {
        return new JobConf((Configuration)new com.aliyun.odps.mapred.conf.JobConf((Configuration)conf));
    }

    public static Writable fromString(byte type, String val, String nullIndicator) throws IOException {
        if (!nullIndicator.equals(val)) {
            switch (type) {
                case 0: {
                    return new LongWritable(Long.parseLong(val));
                }
                case 3: {
                    if (val.startsWith("ODPS-BASE64")) {
                        return new Text(Base64.decodeBase64((String)val.substring("ODPS-BASE64".length())));
                    }
                    try {
                        byte[] v = LocalRunUtils.fromReadableString((String)val);
                        return new Text(v);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("from readable string failed!" + e);
                    }
                }
                case 1: {
                    return new DoubleWritable(Double.parseDouble(val));
                }
                case 2: {
                    return new BooleanWritable(Boolean.parseBoolean(val));
                }
                case 4: {
                    return LocalGraphRunUtils.parseDateTime(val);
                }
            }
            throw new IOException("unsupported type: " + type);
        }
        return null;
    }

    private static Writable parseDateTime(String val) throws IOException {
        try {
            return new DatetimeWritable(Long.parseLong(val));
        }
        catch (NumberFormatException e) {
            try {
                return new DatetimeWritable(DATETIME_FORMAT.parse(val).getTime());
            }
            catch (ParseException ex) {
                throw new IOException("unsupported date time format:" + val);
            }
        }
    }

    private static TableInfo[] getTables(JobConf conf, String descKey) throws IOException {
        String inputDesc = conf.get(descKey, "[]");
        if (inputDesc != "[]") {
            JsonArray inputs = new JsonParser().parse(inputDesc).getAsJsonArray();
            TableInfo[] infos = new TableInfo[inputs.size()];
            for (int i = 0; i < inputs.size(); ++i) {
                TableInfo info;
                String tmpLabel;
                String tblName;
                String projName;
                JsonObject input = inputs.get(i).getAsJsonObject();
                String string = projName = input.has("projName") ? input.get("projName").getAsString() : null;
                if (StringUtils.isEmpty((String)projName)) {
                    projName = SessionState.get().getOdps().getDefaultProject();
                }
                String string2 = tblName = input.has("tblName") ? input.get("tblName").getAsString() : null;
                if (StringUtils.isEmpty((String)tblName)) {
                    throw new IOException("ODPS-0720001: Invalid table name format - input table name cann't be empty: " + input);
                }
                JsonArray parts = input.has("partSpec") ? input.get("partSpec").getAsJsonArray() : new JsonArray();
                LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
                for (int j = 0; j < parts.size(); ++j) {
                    String part = parts.get(j).getAsString();
                    String[] part_val = part.split("=");
                    partSpec.put(part_val[0], part_val[1]);
                }
                String[] cols = null;
                if (input.has("cols")) {
                    String readCols = input.get("cols").getAsString();
                    cols = readCols.split("\\,");
                    for (int cur = 0; cur < cols.length; ++cur) {
                        for (int k = cur + 1; k < cols.length; ++k) {
                            if (!cols[cur].equals(cols[k])) continue;
                            throw new IOException("ODPS-0720091: Column duplicate - " + cols[cur]);
                        }
                    }
                }
                String label = "__default__";
                if (input.has("label") && !StringUtils.isEmpty((String)(tmpLabel = input.get("label").getAsString()))) {
                    label = tmpLabel;
                }
                infos[i] = info = TableInfo.builder().tableName(tblName).projectName(projName).partSpec(partSpec).cols(cols).label(label).build();
            }
            return infos;
        }
        return new TableInfo[0];
    }

    public static TableInfo[] getInputTables(JobConf conf) throws IOException {
        return LocalGraphRunUtils.getTables(conf, "odps.graph.input.desc");
    }

    public static TableInfo[] getOutputTables(JobConf conf) throws IOException {
        return LocalGraphRunUtils.getTables(conf, "odps.graph.output.desc");
    }

    public static Writable[] createFileds(byte[] types) {
        Writable[] fields = new Writable[types.length];
        block7: for (int i = 0; i < fields.length; ++i) {
            switch (types[i]) {
                case 0: {
                    fields[i] = new LongWritable();
                    continue block7;
                }
                case 1: {
                    fields[i] = new DoubleWritable();
                    continue block7;
                }
                case 2: {
                    fields[i] = new BooleanWritable();
                    continue block7;
                }
                case 3: {
                    fields[i] = new Text();
                    continue block7;
                }
                case 4: {
                    fields[i] = new DatetimeWritable();
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unsupported column type: " + types[i]);
                }
            }
        }
        return fields;
    }
}

