/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.udf.InvalidInvocationException;
import com.aliyun.odps.volume.FileSystem;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public abstract class ExecutionContext {
    protected String stageID;
    protected int workerID;
    protected int retryCount = -1;
    protected int backupWorkerID = -1;
    protected String tableInfo;
    protected String localResourceDirectory;
    protected String instanceID;
    protected String runningProject;
    private static final int MAX_COUNTERS_NUM = 64;
    private static final int MAX_COUNTERS_LEN = 100;
    protected int countersNumberLimit = 64;
    protected Counters counters = new Counters();
    protected HashMap<String, Counter> userCounters = new HashMap();

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getStageID() {
        return this.stageID;
    }

    public int getWorkerID() {
        return this.workerID;
    }

    public String getRunningProject() {
        return this.runningProject;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getBackupWorkerID() {
        return this.backupWorkerID;
    }

    public String getTableInfo() {
        if (this.tableInfo == null) {
            throw new InvalidInvocationException("table info is only available at mapper.");
        }
        return this.tableInfo;
    }

    public abstract void claimAlive();

    public Counter getCounter(Enum<?> name) {
        if (name == null) {
            throw new IllegalArgumentException("Counter name must not be null.");
        }
        return this.getCounter(name.getDeclaringClass().getName(), name.toString());
    }

    public Counter getCounter(String group, String name) {
        String key = group + "#" + name;
        if (this.userCounters.containsKey(key)) {
            return this.userCounters.get(key);
        }
        this.checkUserDefinedCounters(group, name);
        Counter counter = this.counters.findCounter(group, name);
        this.userCounters.put(key, counter);
        return counter;
    }

    private void checkUserDefinedCounters(String groupName, String counterName) {
        if (groupName == null || groupName.isEmpty() || counterName == null || counterName.isEmpty()) {
            throw new IllegalArgumentException("Group or counter name must not be null or empty.");
        }
        if (groupName.contains("#")) {
            throw new IllegalArgumentException("Group name: '" + this.shortenName(groupName) + "' cannot contain character '#'");
        }
        if (counterName.contains("#")) {
            throw new IllegalArgumentException("Counter name: '" + this.shortenName(counterName) + "' cannot contain character '#'");
        }
        int maxLength = 100;
        if (groupName.length() + counterName.length() > maxLength) {
            throw new IllegalArgumentException("Length of group name '" + this.shortenName(groupName) + "' and counter name '" + this.shortenName(counterName) + "' exceeded limit " + maxLength);
        }
        if (this.userCounters.size() >= this.countersNumberLimit) {
            throw new IllegalArgumentException("Total num of user defined counters exceeded limit " + this.countersNumberLimit);
        }
    }

    private String shortenName(String name) {
        if (name.length() > 110) {
            return name.substring(0, 110) + "...";
        }
        return name;
    }

    public abstract BufferedInputStream readResourceFileAsStream(String var1) throws IOException;

    public abstract byte[] readResourceFile(String var1) throws IOException;

    public abstract Iterable<Object[]> readResourceTable(String var1) throws IOException;

    public abstract Iterable<BufferedInputStream> readCacheArchiveAsStream(String var1) throws IOException;

    public abstract Iterable<BufferedInputStream> readCacheArchiveAsStream(String var1, String var2) throws IOException;

    public abstract VolumeInfo getInputVolumeInfo() throws IOException;

    public abstract VolumeInfo getInputVolumeInfo(String var1) throws IOException;

    public abstract VolumeInfo getOutputVolumeInfo() throws IOException;

    public abstract VolumeInfo getOutputVolumeInfo(String var1) throws IOException;

    public abstract FileSystem getInputVolumeFileSystem() throws IOException;

    public abstract FileSystem getInputVolumeFileSystem(String var1) throws IOException;

    public abstract FileSystem getOutputVolumeFileSystem() throws IOException;

    public abstract FileSystem getOutputVolumeFileSystem(String var1) throws IOException;

    public abstract Properties getConfigurations();

    public abstract FileSystem getTempFileSystem() throws IOException;
}

