/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSAsync;
import com.aliyun.openservices.ots.OTSWriter;
import com.aliyun.openservices.ots.internal.OTSCallback;
import com.aliyun.openservices.ots.internal.writer.RowChangeEvent;
import com.aliyun.openservices.ots.internal.writer.RowChangeEventHandler;
import com.aliyun.openservices.ots.internal.writer.WriterConfig;
import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.DescribeTableRequest;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.OTSFuture;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.TableMeta;
import com.aliyun.openservices.ots.utils.ParamChecker;
import com.aliyun.openservices.ots.utils.Preconditions;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOTSWriter
implements OTSWriter {
    private Logger logger = LoggerFactory.getLogger(OTSWriter.class);
    private OTSAsync ots;
    private Executor executor;
    private WriterConfig writerConfig;
    private OTSCallback<RowChange, ConsumedCapacity> callback;
    private String tableName;
    private TableMeta tableMeta;
    private Timer flushTimer;
    private ReentrantLock lock;
    private Disruptor<RowChangeEvent> disruptor;
    private RingBuffer<RowChangeEvent> ringBuffer;
    private RowChangeEventHandler eventHandler;

    public DefaultOTSWriter(OTSAsync ots, String tableName, WriterConfig config, OTSCallback<RowChange, ConsumedCapacity> callback, Executor executor) {
        Preconditions.checkNotNull(ots, "The ots client can not be null.");
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The table name can not be null or empty.");
        Preconditions.checkNotNull(executor, "The executor service can not be null.");
        this.ots = ots;
        this.tableName = tableName;
        this.writerConfig = config;
        this.callback = callback;
        this.executor = executor;
        this.flushTimer = new Timer();
        this.lock = new ReentrantLock();
        this.initialize();
    }

    private void initialize() {
        this.logger.info("Start initialize ots writer, table name: {}.", (Object)this.tableName);
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(this.tableName);
        OTSFuture<DescribeTableResult> result = this.ots.describeTable(request);
        DescribeTableResult res = result.get();
        this.tableMeta = res.getTableMeta();
        this.logger.info("End initialize with table meta: {}.", (Object)this.tableMeta);
        RowChangeEvent.RowChangeEventFactory factory = new RowChangeEvent.RowChangeEventFactory();
        this.disruptor = new Disruptor((EventFactory)factory, this.writerConfig.getBufferSize(), this.executor);
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.eventHandler = new RowChangeEventHandler(this.ots, this.writerConfig, this.callback, this.executor);
        this.disruptor.handleEventsWith(new EventHandler[]{this.eventHandler});
        this.disruptor.start();
        this.startFlushTimer(this.writerConfig.getFlushInterval());
    }

    public long getTotalRPCCount() {
        return this.eventHandler.getTotalRPCCount();
    }

    public void startFlushTimer(int flushInterval) {
        this.flushTimer.cancel();
        this.flushTimer = new Timer();
        this.flushTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DefaultOTSWriter.this.triggerFlush();
            }
        }, flushInterval, (long)flushInterval);
    }

    @Override
    public void addRowChange(RowChange rowChange) {
        ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
        while (true) {
            try {
                long sequence = this.ringBuffer.tryNext();
                RowChangeEvent event = (RowChangeEvent)this.ringBuffer.get(sequence);
                event.setValue(rowChange);
                this.ringBuffer.publish(sequence);
                return;
            }
            catch (InsufficientCapacityException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void addSignal(ReentrantLock lock, Condition condition) {
        while (true) {
            try {
                long sequence = this.ringBuffer.tryNext();
                RowChangeEvent event = (RowChangeEvent)this.ringBuffer.get(sequence);
                event.setValue(lock, condition);
                this.ringBuffer.publish(sequence);
                return;
            }
            catch (InsufficientCapacityException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException exp) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public void addRowChange(List<RowChange> rowChanges, List<RowChange> dirtyRows) throws ClientException {
        dirtyRows.clear();
        for (RowChange rowChange : rowChanges) {
            try {
                this.addRowChange(rowChange);
            }
            catch (ClientException e) {
                dirtyRows.add(rowChange);
            }
        }
        if (!dirtyRows.isEmpty()) {
            throw new ClientException("There is dirty rows.");
        }
    }

    @Override
    public void setCallback(OTSCallback<RowChange, ConsumedCapacity> callback) {
        this.callback = callback;
    }

    @Override
    public OTSCallback<RowChange, ConsumedCapacity> getCallback() {
        return this.callback;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    private void triggerFlush() {
        Condition cond = this.lock.newCondition();
        this.addSignal(this.lock, cond);
    }

    @Override
    public synchronized void flush() throws ClientException {
        this.logger.debug("trigger flush and waiting.");
        Condition cond = this.lock.newCondition();
        this.lock.lock();
        try {
            this.addSignal(this.lock, cond);
            cond.await();
        }
        catch (InterruptedException e) {
            throw new ClientException(e);
        }
        finally {
            this.lock.unlock();
        }
        this.logger.debug("user trigger flush finished.");
    }

    @Override
    public synchronized void close() {
        this.flushTimer.cancel();
        this.flush();
        this.disruptor.shutdown();
    }
}

