/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots;

import com.aliyun.openservices.ots.ClientConfiguration;
import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSAsync;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.comm.AsyncClientFutureCallback;
import com.aliyun.openservices.ots.comm.AsyncServiceClient;
import com.aliyun.openservices.ots.comm.ServiceClient;
import com.aliyun.openservices.ots.internal.BatchGetRowCallable;
import com.aliyun.openservices.ots.internal.BatchGetRowExecutionContext;
import com.aliyun.openservices.ots.internal.BatchWriteRowCallable;
import com.aliyun.openservices.ots.internal.BatchWriteRowExecutionContext;
import com.aliyun.openservices.ots.internal.CreateTableCallable;
import com.aliyun.openservices.ots.internal.DeleteRowCallable;
import com.aliyun.openservices.ots.internal.DeleteTableCallable;
import com.aliyun.openservices.ots.internal.DescribeTableCallable;
import com.aliyun.openservices.ots.internal.GetRangeCallable;
import com.aliyun.openservices.ots.internal.GetRowCallable;
import com.aliyun.openservices.ots.internal.ListTableCallable;
import com.aliyun.openservices.ots.internal.OTSAsyncDataOperation;
import com.aliyun.openservices.ots.internal.OTSAsyncTableOperation;
import com.aliyun.openservices.ots.internal.OTSCallback;
import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSRetryStrategy;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.PutRowCallable;
import com.aliyun.openservices.ots.internal.UpdateRowCallable;
import com.aliyun.openservices.ots.internal.UpdateTableCallable;
import com.aliyun.openservices.ots.model.BatchGetRowRequest;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.CreateTableRequest;
import com.aliyun.openservices.ots.model.CreateTableResult;
import com.aliyun.openservices.ots.model.DeleteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.DeleteTableRequest;
import com.aliyun.openservices.ots.model.DeleteTableResult;
import com.aliyun.openservices.ots.model.DescribeTableRequest;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.GetRangeRequest;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.GetRowRequest;
import com.aliyun.openservices.ots.model.GetRowResult;
import com.aliyun.openservices.ots.model.ListTableRequest;
import com.aliyun.openservices.ots.model.ListTableResult;
import com.aliyun.openservices.ots.model.OTSBasicFuture;
import com.aliyun.openservices.ots.model.OTSContext;
import com.aliyun.openservices.ots.model.OTSFuture;
import com.aliyun.openservices.ots.model.OTSFutureCallback;
import com.aliyun.openservices.ots.model.PutRowRequest;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.UpdateRowRequest;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import com.aliyun.openservices.ots.model.UpdateTableRequest;
import com.aliyun.openservices.ots.model.UpdateTableResult;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class OTSClientAsync
implements OTSAsync {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private String endpoint;
    private String instanceName;
    private ServiceCredentials credentials;
    private ServiceClient client;
    private ScheduledExecutorService retryExecutor;
    private ExecutorService callbackExecutor;
    private OTSServiceConfiguration serviceConfig;
    private OTSAsyncTableOperation asyncTableOp;
    private OTSAsyncDataOperation asyncDataOp;
    private OTSRetryStrategy retryStrategy;
    private Random random = new Random();

    public OTSClientAsync(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null, null, null);
    }

    public OTSClientAsync(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null, null, null, stsToken);
    }

    public OTSClientAsync(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, OTSServiceConfiguration otsConfig) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, otsConfig, null);
    }

    public OTSClientAsync(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null, null);
    }

    public OTSClientAsync(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, OTSServiceConfiguration otsConfig, ExecutorService callbackExecutor) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, otsConfig, callbackExecutor, null);
    }

    public OTSClientAsync(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, OTSServiceConfiguration otsConfig, ExecutorService callbackExecutor, String stsToken) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        CodingUtils.assertStringNotNullOrEmpty(accessKeyId, "accessKeyId");
        CodingUtils.assertStringNotNullOrEmpty(accessKeySecret, "accessKeySecret");
        CodingUtils.assertStringNotNullOrEmpty(instanceName, "instanceName");
        try {
            Preconditions.checkArgument(instanceName.length() == instanceName.getBytes("utf-8").length, "InstanceName should not have multibyte character.");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ClientException("UnsupportedEncoding", ex);
        }
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointProtocolInvalid"));
        }
        this.endpoint = endpoint;
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret, stsToken);
        if (config == null) {
            config = new ClientConfiguration();
        }
        this.client = new AsyncServiceClient(config);
        this.retryExecutor = Executors.newScheduledThreadPool(config.getRetryThreadCount());
        this.serviceConfig = otsConfig != null ? otsConfig : new OTSServiceConfiguration();
        this.retryStrategy = this.serviceConfig.getRetryStrategy();
        this.instanceName = instanceName;
        this.callbackExecutor = callbackExecutor != null ? callbackExecutor : Executors.newFixedThreadPool(AVAILABLE_PROCESSORS);
        this.asyncTableOp = new OTSAsyncTableOperation(this.endpoint, this.instanceName, this.client, this.credentials, this.serviceConfig);
        this.asyncDataOp = new OTSAsyncDataOperation(this.endpoint, this.instanceName, this.client, this.credentials, this.serviceConfig);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    private OTSAsyncTableOperation getAsyncTableOperation() {
        return this.asyncTableOp;
    }

    private OTSAsyncDataOperation getAsyncDataOperation() {
        return this.asyncDataOp;
    }

    private OTSTraceLogger getOTSTraceLogger() {
        String traceId = new UUID(this.random.nextLong(), new Random().nextLong()).toString();
        OTSTraceLogger traceLogger = new OTSTraceLogger(traceId, this.serviceConfig.getTimeThresholdOfTraceLogger());
        return traceLogger;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.asyncDataOp.setExtraHeaders(extraHeaders);
        this.asyncTableOp.setExtraHeaders(extraHeaders);
    }

    private <Req, Res> OTSFutureCallback<Res> buildOTSBasicFutureCallback(final Req request, final OTSCallback<Req, Res> otsCallback) {
        if (otsCallback == null) {
            return null;
        }
        return new OTSFutureCallback<Res>(){

            @Override
            public void completed(Res result) {
                final OTSContext otsContext = new OTSContext(request, result);
                OTSClientAsync.this.callbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        otsCallback.onCompleted(otsContext);
                    }
                });
            }

            @Override
            public void failed(final Exception ex) {
                final OTSContext<Object, Object> otsContext = new OTSContext<Object, Object>(request, null);
                if (ex instanceof OTSException) {
                    OTSClientAsync.this.callbackExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            otsCallback.onFailed(otsContext, (OTSException)ex);
                        }
                    });
                } else if (ex instanceof ClientException) {
                    OTSClientAsync.this.callbackExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            otsCallback.onFailed(otsContext, (ClientException)ex);
                        }
                    });
                }
            }
        };
    }

    @Override
    public OTSFuture<ListTableResult> listTable() throws ClientException {
        return this.listTable(null);
    }

    @Override
    public OTSFuture<ListTableResult> listTable(OTSCallback<ListTableRequest, ListTableResult> callback) throws ClientException {
        OTSBasicFuture<ListTableResult> future = new OTSBasicFuture<ListTableResult>(this.buildOTSBasicFutureCallback(null, callback));
        OTSExecutionContext<Object, ListTableResult> executionContext = new OTSExecutionContext<Object, ListTableResult>(null, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<ListTableResult>("ListTable", executionContext));
        executionContext.setCallable(new ListTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<CreateTableResult> createTable(CreateTableRequest createTableRequest) throws ClientException {
        return this.createTable(createTableRequest, null);
    }

    @Override
    public OTSFuture<CreateTableResult> createTable(CreateTableRequest createTableRequest, OTSCallback<CreateTableRequest, CreateTableResult> callback) throws ClientException {
        Preconditions.checkNotNull(createTableRequest);
        OTSBasicFuture<CreateTableResult> future = new OTSBasicFuture<CreateTableResult>(this.buildOTSBasicFutureCallback(createTableRequest, callback));
        OTSExecutionContext<CreateTableRequest, CreateTableResult> executionContext = new OTSExecutionContext<CreateTableRequest, CreateTableResult>(createTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<CreateTableResult>("CreateTable", executionContext));
        executionContext.setCallable(new CreateTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<DescribeTableResult> describeTable(DescribeTableRequest describeTableRequest) throws ClientException {
        return this.describeTable(describeTableRequest, null);
    }

    @Override
    public OTSFuture<DescribeTableResult> describeTable(DescribeTableRequest describeTableRequest, OTSCallback<DescribeTableRequest, DescribeTableResult> callback) throws ClientException {
        Preconditions.checkNotNull(describeTableRequest);
        OTSBasicFuture<DescribeTableResult> future = new OTSBasicFuture<DescribeTableResult>(this.buildOTSBasicFutureCallback(describeTableRequest, callback));
        OTSExecutionContext<DescribeTableRequest, DescribeTableResult> executionContext = new OTSExecutionContext<DescribeTableRequest, DescribeTableResult>(describeTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<DescribeTableResult>("DescribeTable", executionContext));
        executionContext.setCallable(new DescribeTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<DeleteTableResult> deleteTable(DeleteTableRequest deleteTableRequest) throws ClientException {
        return this.deleteTable(deleteTableRequest, null);
    }

    @Override
    public OTSFuture<DeleteTableResult> deleteTable(DeleteTableRequest deleteTableRequest, OTSCallback<DeleteTableRequest, DeleteTableResult> callback) throws ClientException {
        Preconditions.checkNotNull(deleteTableRequest);
        OTSBasicFuture<DeleteTableResult> future = new OTSBasicFuture<DeleteTableResult>(this.buildOTSBasicFutureCallback(deleteTableRequest, callback));
        OTSExecutionContext<DeleteTableRequest, DeleteTableResult> executionContext = new OTSExecutionContext<DeleteTableRequest, DeleteTableResult>(deleteTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<DeleteTableResult>("DeleteTable", executionContext));
        executionContext.setCallable(new DeleteTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<UpdateTableResult> updateTable(UpdateTableRequest updateTableRequest) throws ClientException {
        return this.updateTable(updateTableRequest, null);
    }

    @Override
    public OTSFuture<UpdateTableResult> updateTable(UpdateTableRequest updateTableRequest, OTSCallback<UpdateTableRequest, UpdateTableResult> callback) throws ClientException {
        Preconditions.checkNotNull(updateTableRequest);
        OTSBasicFuture<UpdateTableResult> future = new OTSBasicFuture<UpdateTableResult>(this.buildOTSBasicFutureCallback(updateTableRequest, callback));
        OTSExecutionContext<UpdateTableRequest, UpdateTableResult> executionContext = new OTSExecutionContext<UpdateTableRequest, UpdateTableResult>(updateTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<UpdateTableResult>("UpdateTable", executionContext));
        executionContext.setCallable(new UpdateTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<GetRowResult> getRow(GetRowRequest getRowRequest) throws ClientException {
        return this.getRow(getRowRequest, null);
    }

    @Override
    public OTSFuture<GetRowResult> getRow(GetRowRequest getRowRequest, OTSCallback<GetRowRequest, GetRowResult> callback) throws ClientException {
        Preconditions.checkNotNull(getRowRequest);
        OTSBasicFuture<GetRowResult> future = new OTSBasicFuture<GetRowResult>(this.buildOTSBasicFutureCallback(getRowRequest, callback));
        OTSExecutionContext<GetRowRequest, GetRowResult> executionContext = new OTSExecutionContext<GetRowRequest, GetRowResult>(getRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<GetRowResult>("GetRow", executionContext));
        executionContext.setCallable(new GetRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<PutRowResult> putRow(PutRowRequest putRowRequest) throws ClientException {
        return this.putRow(putRowRequest, null);
    }

    @Override
    public OTSFuture<PutRowResult> putRow(PutRowRequest putRowRequest, OTSCallback<PutRowRequest, PutRowResult> callback) throws ClientException {
        Preconditions.checkNotNull(putRowRequest);
        OTSBasicFuture<PutRowResult> future = new OTSBasicFuture<PutRowResult>(this.buildOTSBasicFutureCallback(putRowRequest, callback));
        OTSExecutionContext<PutRowRequest, PutRowResult> executionContext = new OTSExecutionContext<PutRowRequest, PutRowResult>(putRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<PutRowResult>("PutRow", executionContext));
        executionContext.setCallable(new PutRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<UpdateRowResult> updateRow(UpdateRowRequest updateRowRequest) throws ClientException {
        return this.updateRow(updateRowRequest, null);
    }

    @Override
    public OTSFuture<UpdateRowResult> updateRow(UpdateRowRequest updateRowRequest, OTSCallback<UpdateRowRequest, UpdateRowResult> callback) throws ClientException {
        Preconditions.checkNotNull(updateRowRequest);
        OTSBasicFuture<UpdateRowResult> future = new OTSBasicFuture<UpdateRowResult>(this.buildOTSBasicFutureCallback(updateRowRequest, callback));
        OTSExecutionContext<UpdateRowRequest, UpdateRowResult> executionContext = new OTSExecutionContext<UpdateRowRequest, UpdateRowResult>(updateRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<UpdateRowResult>("UpdateRow", executionContext));
        executionContext.setCallable(new UpdateRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<DeleteRowResult> deleteRow(DeleteRowRequest deleteRowRequest) throws ClientException {
        return this.deleteRow(deleteRowRequest, null);
    }

    @Override
    public OTSFuture<DeleteRowResult> deleteRow(DeleteRowRequest deleteRowRequest, OTSCallback<DeleteRowRequest, DeleteRowResult> callback) throws ClientException {
        Preconditions.checkNotNull(deleteRowRequest);
        OTSBasicFuture<DeleteRowResult> future = new OTSBasicFuture<DeleteRowResult>(this.buildOTSBasicFutureCallback(deleteRowRequest, callback));
        OTSExecutionContext<DeleteRowRequest, DeleteRowResult> executionContext = new OTSExecutionContext<DeleteRowRequest, DeleteRowResult>(deleteRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<DeleteRowResult>("DeleteRow", executionContext));
        executionContext.setCallable(new DeleteRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<BatchGetRowResult> batchGetRow(BatchGetRowRequest batchGetRowRequest) throws ClientException {
        return this.batchGetRow(batchGetRowRequest, null);
    }

    @Override
    public OTSFuture<BatchGetRowResult> batchGetRow(BatchGetRowRequest batchGetRowRequest, OTSCallback<BatchGetRowRequest, BatchGetRowResult> callback) throws ClientException {
        Preconditions.checkNotNull(batchGetRowRequest);
        OTSBasicFuture<BatchGetRowResult> future = new OTSBasicFuture<BatchGetRowResult>(this.buildOTSBasicFutureCallback(batchGetRowRequest, callback));
        BatchGetRowExecutionContext executionContext = new BatchGetRowExecutionContext(batchGetRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<BatchGetRowResult>("BatchGetRow", executionContext));
        executionContext.setCallable(new BatchGetRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<BatchWriteRowResult> batchWriteRow(BatchWriteRowRequest batchWriteRowRequest) throws ClientException {
        return this.batchWriteRow(batchWriteRowRequest, null);
    }

    @Override
    public OTSFuture<BatchWriteRowResult> batchWriteRow(BatchWriteRowRequest batchWriteRowRequest, OTSCallback<BatchWriteRowRequest, BatchWriteRowResult> callback) throws ClientException {
        Preconditions.checkNotNull(batchWriteRowRequest);
        OTSBasicFuture<BatchWriteRowResult> future = new OTSBasicFuture<BatchWriteRowResult>(this.buildOTSBasicFutureCallback(batchWriteRowRequest, callback));
        BatchWriteRowExecutionContext executionContext = new BatchWriteRowExecutionContext(batchWriteRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<BatchWriteRowResult>("BatchWriteRow", executionContext));
        executionContext.setCallable(new BatchWriteRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public OTSFuture<GetRangeResult> getRange(GetRangeRequest getRangeRequest) throws ClientException {
        return this.getRange(getRangeRequest, null);
    }

    @Override
    public OTSFuture<GetRangeResult> getRange(GetRangeRequest getRangeRequest, OTSCallback<GetRangeRequest, GetRangeResult> callback) throws ClientException {
        Preconditions.checkNotNull(getRangeRequest);
        OTSBasicFuture<GetRangeResult> future = new OTSBasicFuture<GetRangeResult>(this.buildOTSBasicFutureCallback(getRangeRequest, callback));
        OTSExecutionContext<GetRangeRequest, GetRangeResult> executionContext = new OTSExecutionContext<GetRangeRequest, GetRangeResult>(getRangeRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<GetRangeResult>("GetRange", executionContext));
        executionContext.setCallable(new GetRangeCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future;
    }

    @Override
    public void shutdown() {
        this.retryExecutor.shutdown();
        this.callbackExecutor.shutdown();
        this.client.shutdown();
    }
}

