/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.comm;

import com.aliyun.openservices.ots.ClientConfiguration;
import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.comm.ExecutionContext;
import com.aliyun.openservices.ots.comm.HttpFactory;
import com.aliyun.openservices.ots.comm.RequestMessage;
import com.aliyun.openservices.ots.comm.ServiceClient;
import com.aliyun.openservices.ots.internal.OTSAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.log.LogUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;

public class AsyncServiceClient
extends ServiceClient {
    private CloseableHttpAsyncClient httpClient;
    private IdleConnectionEvictor connEvictor;

    public AsyncServiceClient(ClientConfiguration config) {
        super(config);
        try {
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoThreadCount()).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            cm.setMaxTotal(config.getMaxConnections());
            cm.setDefaultMaxPerRoute(config.getMaxConnections());
            this.httpClient = new HttpFactory().createHttpAsyncClient(config, cm);
            long closePeriod = 5000L;
            if (config.getSocketTimeoutInMillisecond() > 0) {
                closePeriod = (long)((double)config.getSocketTimeoutInMillisecond() / 2.5);
            }
            closePeriod = closePeriod < 5000L ? closePeriod : 5000L;
            this.connEvictor = new IdleConnectionEvictor((NHttpClientConnectionManager)cm, closePeriod);
            this.httpClient.start();
            this.connEvictor.start();
        }
        catch (IOReactorException ex) {
            throw new ClientException(String.format("IOReactorError: %s", ex.getMessage()), ex);
        }
    }

    @Override
    protected <Res> void asyncSendRequestCore(RequestMessage request, ExecutionContext context, OTSAsyncResponseConsumer<Res> consumer, FutureCallback<Res> callback, OTSTraceLogger traceLogger) {
        HttpHost target = request.getActionUri().getHost();
        if (LogUtil.LOG.isDebugEnabled()) {
            LogUtil.LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "IntoHttpAsyncClient");
        }
        traceLogger.addEventTime("IntoHttpAsyncClient", System.currentTimeMillis());
        this.httpClient.execute((HttpAsyncRequestProducer)new OTSRequestProducer(target, (HttpRequest)request.getRequest(), traceLogger), consumer, callback);
    }

    @Override
    public void shutdown() {
        try {
            this.connEvictor.shutdown();
            this.connEvictor.join();
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new ClientException(rm.getFormattedString("IOError", e.getMessage()), e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class OTSRequestProducer
    extends BasicAsyncRequestProducer {
        private OTSTraceLogger traceLogger;

        public OTSRequestProducer(HttpHost target, HttpRequest request, OTSTraceLogger traceLogger) {
            super(target, request);
            this.traceLogger = traceLogger;
        }

        public void requestCompleted(HttpContext context) {
            super.requestCompleted(context);
            if (LogUtil.LOG.isDebugEnabled()) {
                LogUtil.LOG.debug("TraceId:" + this.traceLogger.getTraceId() + "\t" + "RequestSent");
            }
            this.traceLogger.addEventTime("RequestSent", System.currentTimeMillis());
        }
    }

    public static class IdleConnectionEvictor
    extends Thread {
        private final NHttpClientConnectionManager connMgr;
        private volatile boolean shutdown;
        private long closePeriod;

        public IdleConnectionEvictor(NHttpClientConnectionManager connMgr, long closePeriod) {
            this.connMgr = connMgr;
            this.closePeriod = closePeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionEvictor idleConnectionEvictor = this;
                    synchronized (idleConnectionEvictor) {
                        this.wait(this.closePeriod);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(this.closePeriod, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionEvictor idleConnectionEvictor = this;
            synchronized (idleConnectionEvictor) {
                this.notifyAll();
            }
        }
    }
}

