/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.PartialResultFailedException;
import com.aliyun.openservices.ots.internal.BatchGetRowExecutionContext;
import com.aliyun.openservices.ots.internal.OTSAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.log.LogUtil;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.OTSResult;
import com.aliyun.openservices.ots.model.OTSResultFactory;
import com.aliyun.openservices.ots.parser.ResultParser;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import java.util.List;
import java.util.Map;

class BatchGetRowAsyncResponseConsumer
extends OTSAsyncResponseConsumer<BatchGetRowResult> {
    private BatchGetRowExecutionContext executionContext;

    public BatchGetRowAsyncResponseConsumer(ResultParser resultParser, BatchGetRowExecutionContext executionContext) {
        super(resultParser, executionContext.getTraceLogger());
        this.executionContext = executionContext;
    }

    BatchGetRowResult mergeResult(BatchGetRowResult lastResult, BatchGetRowResult result) {
        OTSResult meta = new OTSResult(result.getRequestID());
        meta.setTraceId(this.traceLogger.getTraceId());
        BatchGetRowResult mergedResult = new BatchGetRowResult(meta);
        Map<String, List<BatchGetRowResult.RowStatus>> lastRowResultMap = lastResult.getTableToRowsStatus();
        Map<String, List<BatchGetRowResult.RowStatus>> rowResultMap = result.getTableToRowsStatus();
        for (String tableName : lastRowResultMap.keySet()) {
            List<BatchGetRowResult.RowStatus> lastRowResultList = lastRowResultMap.get(tableName);
            List<BatchGetRowResult.RowStatus> rowResultList = rowResultMap.get(tableName);
            int idx = 0;
            for (BatchGetRowResult.RowStatus lastRowResult : lastRowResultList) {
                BatchGetRowResult.RowStatus rowResult;
                if (lastRowResult.isSucceed()) {
                    mergedResult.addResult(lastRowResult);
                    continue;
                }
                if ((rowResult = rowResultList.get(idx++)).isSucceed()) {
                    mergedResult.addResult(new BatchGetRowResult.RowStatus(tableName, rowResult.getRow(), rowResult.getConsumedCapacity(), lastRowResult.getIndex()));
                    continue;
                }
                mergedResult.addResult(new BatchGetRowResult.RowStatus(tableName, rowResult.getError(), lastRowResult.getIndex()));
            }
        }
        return mergedResult;
    }

    @Override
    protected BatchGetRowResult parseResult() throws Exception {
        List<BatchGetRowResult.RowStatus> failedRows;
        ResponseContentWithMeta responseContent = this.getResponseContentWithMeta();
        OtsProtocol2.BatchGetRowResponse batchGetRowResponse = (OtsProtocol2.BatchGetRowResponse)responseContent.getMessage();
        BatchGetRowResult result = OTSResultFactory.createBatchGetRowResult(responseContent, batchGetRowResponse);
        BatchGetRowResult lastResult = this.executionContext.getLastResult();
        if (lastResult != null) {
            result = this.mergeResult(lastResult, result);
        }
        if ((failedRows = result.getFailedRows()).isEmpty()) {
            return result;
        }
        PartialResultFailedException partialEx = new PartialResultFailedException(null, result.getRequestID(), result);
        for (BatchGetRowResult.RowStatus rowResult : failedRows) {
            OTSException ex = new OTSException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestID(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.executionContext, ex, result.getRequestID());
        }
        throw partialEx;
    }
}

