/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.internal.OTSRetryStrategy;

public class OTSAlwaysRetryStrategy
implements OTSRetryStrategy {
    private int retryPauseInMillis = 50;
    private int maxRetryTimes = 3;
    private int maxRetryPauseInMillis = 1000;

    public int getRetryPauseInMillis() {
        return this.retryPauseInMillis;
    }

    public void setRetryPauseInMillis(int retryPauseInMillis) {
        this.retryPauseInMillis = retryPauseInMillis;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getMaxRetryPauseInMillis() {
        return this.maxRetryPauseInMillis;
    }

    public void setMaxRetryPauseInMillis(int maxRetryPauseInMillis) {
        this.maxRetryPauseInMillis = maxRetryPauseInMillis;
    }

    @Override
    public boolean shouldRetry(String action, Exception ex, int retries) {
        return retries <= this.maxRetryTimes;
    }

    @Override
    public long getPauseDelay(String action, Exception ex, int retries) {
        int scale = this.retryPauseInMillis;
        long delay = (long)Math.pow(2.0, retries) * (long)scale;
        return Math.min(delay, (long)this.maxRetryPauseInMillis);
    }
}

