/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.comm.ResponseHandler;
import com.aliyun.openservices.ots.comm.ResponseMessage;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.utils.BinaryUtil;
import com.aliyun.openservices.ots.utils.IOUtils;
import com.aliyun.openservices.ots.utils.ResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;

public class OTSContentMD5ResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws ClientException {
        Map<String, String> headers = responseData.getHeadersMap();
        if (!headers.containsKey("x-ots-contentmd5")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-contentmd5"), null);
        }
        String contentMd5 = headers.get("x-ots-contentmd5");
        byte[] content = null;
        String md5 = null;
        InputStream dataStream = null;
        try {
            dataStream = responseData.getContent();
        }
        catch (IOException e) {
            throw new ClientException("Can not read response from server.", e);
        }
        if (dataStream == null) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        try {
            content = IOUtils.readStreamAsBytesArray(dataStream);
            md5 = BinaryUtil.toBase64String(BinaryUtil.calculateMd5(content));
        }
        catch (Exception e) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        if (!md5.equals(contentMd5)) {
            throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ResponseContentMD5Invalid"));
        }
        IOUtils.safeClose(dataStream);
        responseData.getResponse().setEntity((HttpEntity)new ByteArrayEntity(content));
    }
}

