/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.model.OTSFuture;
import com.aliyun.openservices.ots.model.OTSFutureCallback;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.util.Args;

public class OTSBasicFuture<T>
implements OTSFuture<T> {
    private final OTSFutureCallback<T> callback;
    private volatile boolean completed;
    private volatile T result;
    private volatile Exception ex;

    public OTSBasicFuture(OTSFutureCallback<T> callback) {
        this.callback = callback;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    private T getResult() throws OTSException, ClientException {
        if (this.ex instanceof OTSException) {
            OTSException tmp = (OTSException)this.ex;
            OTSException newExp = new OTSException(tmp.getMessage(), (Throwable)tmp, tmp.getErrorCode(), tmp.getRequestId(), tmp.getHttpStatus());
            newExp.setTraceId(tmp.getTraceId());
            throw newExp;
        }
        if (this.ex instanceof ClientException) {
            throw new ClientException(this.ex.getMessage(), this.ex, ((ClientException)this.ex).getTraceId());
        }
        return this.result;
    }

    @Override
    public synchronized T get() throws OTSException, ClientException {
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
            }
        }
        return this.getResult();
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws OTSException, ClientException, TimeoutException {
        Args.notNull((Object)((Object)unit), (String)"Time unit");
        long msecs = unit.toMillis(timeout);
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.completed) {
            return this.getResult();
        }
        if (waitTime <= 0L) {
            throw new TimeoutException();
        }
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
            }
            if (!this.completed) continue;
            return this.getResult();
        } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
        throw new TimeoutException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completed(T result) {
        OTSBasicFuture oTSBasicFuture = this;
        synchronized (oTSBasicFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.result = result;
            this.notifyAll();
        }
        if (this.callback != null) {
            this.callback.completed(result);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed(Exception exception) {
        OTSBasicFuture oTSBasicFuture = this;
        synchronized (oTSBasicFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.ex = exception;
            this.notifyAll();
        }
        if (this.callback != null) {
            this.callback.failed(exception);
        }
        return true;
    }
}

