/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.condition.ColumnCondition;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RowQueryCriteria {
    private String tableName;
    private List<String> columnsToGet = new LinkedList<String>();
    private ColumnCondition filter;

    public RowQueryCriteria(String tableName) {
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        CodingUtils.assertStringNotNullOrEmpty(tableName, "tableName");
        this.tableName = tableName;
    }

    public List<String> getColumnsToGet() {
        return Collections.unmodifiableList(this.columnsToGet);
    }

    public void addColumnsToGet(String columnName) {
        CodingUtils.assertStringNotNullOrEmpty(columnName, "columnName");
        this.columnsToGet.add(columnName);
    }

    public void addColumnsToGet(String[] columnNames) {
        CodingUtils.assertParameterNotNull(columnNames, "columnNames");
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnsToGet.add(columnNames[i]);
        }
    }

    public void setColumnsToGet(List<String> columnsToGet) {
        CodingUtils.assertParameterNotNull(columnsToGet, "columnsToGet");
        this.columnsToGet = columnsToGet;
    }

    public ColumnCondition getFilter() {
        return this.filter;
    }

    public void setFilter(ColumnCondition filter) {
        CodingUtils.assertParameterNotNull(filter, "filter");
        this.filter = filter;
    }

    public void copyTo(RowQueryCriteria target) {
        target.tableName = this.tableName;
        target.columnsToGet.addAll(this.columnsToGet);
        target.filter = this.filter;
    }
}

