/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.resource.busi.IpAutoAssignService;
import com.apstar.resource.busi.bo.IpAutoAssignReqBO;
import com.apstar.resource.busi.bo.IpAutoAssignRspBO;
import com.apstar.resource.dao.IpInstanceDao;
import com.apstar.resource.dao.IpSegmentDao;
import com.apstar.resource.dao.VlanDao;
import com.apstar.resource.po.IpInstancePO;
import com.apstar.resource.po.IpSegmentPO;
import com.apstar.resource.po.VlanPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ipAutoAssignService")
public class IpAutoAssignServiceImpl
implements IpAutoAssignService {
    private static final Logger logger = LoggerFactory.getLogger(IpAutoAssignServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private IpSegmentDao ipSegmentDao;
    @Autowired
    private IpInstanceDao ipInstanceDao;
    @Autowired
    private VlanDao vlanDao;

    public IpAutoAssignRspBO ipAutoAssign(IpAutoAssignReqBO ipAutoAssignReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2ipAutoAssignReqBO\uff1a" + ipAutoAssignReqBO.toString());
        }
        this.checkParameter(ipAutoAssignReqBO);
        try {
            if (0 == ipAutoAssignReqBO.getResIpType()) {
                List<IpSegmentPO> ipSegmentList = this.selectIpSegment(ipAutoAssignReqBO);
                if (null == ipSegmentList || ipSegmentList.size() == 0) {
                    throw new BusinessException("10003", "\u8be5VLAN\u7684IP\u8d44\u6e90\u5df2\u4f7f\u7528\u5b8c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6VLAN");
                }
                for (IpSegmentPO ipSegmentPO : ipSegmentList) {
                    List<IpInstancePO> ipInstanceList = this.ipInstanceDao.selectByvlanId(ipSegmentPO);
                    int a = 0;
                    if (null != ipInstanceList && ipInstanceList.size() > 0) {
                        a = Integer.valueOf(this.subIpLast(ipInstanceList.get(0).getResEndIp()));
                    }
                    if (a + ipAutoAssignReqBO.getIpNum() >= Integer.valueOf(this.subIpLast(ipSegmentPO.getResEndIp()))) continue;
                    String vlanCode = this.selectVlanByVlanId(ipAutoAssignReqBO.getVlanId());
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException("10003", e.getMessage());
            }
            throw new BusinessException("10003", "IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u51fa\u9519");
        }
        return null;
    }

    private String selectSubnetMask(Integer ipNum) {
        return "";
    }

    private String selectVlanByVlanId(Long vlanId) {
        VlanPO vlanPO = this.vlanDao.selectByPrimaryKey(vlanId);
        return vlanPO.getVlanCode();
    }

    private String subIpLast(String str) {
        if (null == str) {
            throw new BusinessException("10003", "IP\u622a\u53d6\u5931\u8d25");
        }
        String newStr = str.substring(str.lastIndexOf(".") + 1);
        return newStr;
    }

    public static void main(String[] args) {
        IpAutoAssignServiceImpl ipAutoAssignServiceImpl = new IpAutoAssignServiceImpl();
        int newStr = Integer.valueOf(ipAutoAssignServiceImpl.subIpLast("192.168.2.134"));
        System.out.println(newStr);
    }

    private List<IpSegmentPO> selectIpSegment(IpAutoAssignReqBO ipAutoAssignReqBO) {
        IpSegmentPO record = new IpSegmentPO();
        record.setVlanId(ipAutoAssignReqBO.getVlanId());
        record.setResIpType(ipAutoAssignReqBO.getResIpType());
        record.setResIpStatus(0);
        record.setResIpNum(ipAutoAssignReqBO.getIpNum());
        return this.ipSegmentDao.selectByVlanId(record);
    }

    private void checkParameter(IpAutoAssignReqBO ipAutoAssignReqBO) {
        if (null == ipAutoAssignReqBO.getResIpType()) {
            throw new ParametersException("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2[resIpType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0 == ipAutoAssignReqBO.getResIpType() && null == ipAutoAssignReqBO.getVlanId()) {
            throw new ParametersException("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2[vlanId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0 == ipAutoAssignReqBO.getResIpType() && null == ipAutoAssignReqBO.getStaticIpNum()) {
            throw new ParametersException("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2[staticIpNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((0 == ipAutoAssignReqBO.getResIpType() || 1 == ipAutoAssignReqBO.getResIpType()) && null == ipAutoAssignReqBO.getIpNum()) {
            ipAutoAssignReqBO.setIpNum(Integer.valueOf(8));
        }
        if (2 == ipAutoAssignReqBO.getResIpType() && null == ipAutoAssignReqBO.getIpNum()) {
            ipAutoAssignReqBO.setIpNum(Integer.valueOf(1));
        }
    }
}

