/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.bo.rsp.RspBooleanBO;
import com.apstar.resource.busi.ModifyResStatusService;
import com.apstar.resource.busi.bo.ModifyResStatusReqBO;
import com.apstar.resource.dao.DeviceStockDao;
import com.apstar.resource.dao.IpInstanceDao;
import com.apstar.resource.po.DeviceStockPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="modifyResStatusService")
public class ModifyResStatusServiceImpl
implements ModifyResStatusService {
    private static final Logger logger = LoggerFactory.getLogger(ModifyResStatusServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private DeviceStockDao deviceStockDao;
    @Autowired
    private IpInstanceDao ipInstanceDao;

    public RspBooleanBO modifyResStatus(ModifyResStatusReqBO modifyResStatusReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8d44\u6e90\u72b6\u6001\u53d8\u66f4\u670d\u52a1\u5165\u53c2modifyResStatusReqBO\uff1a" + modifyResStatusReqBO.toString());
        }
        if (StringUtils.isEmpty((Object)modifyResStatusReqBO.getResStockIds())) {
            throw new ParametersException("\u8d44\u6e90\u72b6\u6001\u53d8\u66f4\u670d\u52a1\u5165\u53c2[resStockId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)modifyResStatusReqBO.getDeviceStockState())) {
            throw new ParametersException("\u8d44\u6e90\u72b6\u6001\u53d8\u66f4\u670d\u52a1\u5165\u53c2[deviceStockState]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)modifyResStatusReqBO.getResType())) {
            throw new ParametersException("\u8d44\u6e90\u72b6\u6001\u53d8\u66f4\u670d\u52a1\u5165\u53c2[resType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<DeviceStockPO> deviceStockPOs = this.deviceStockDao.selectByResStockIds(modifyResStatusReqBO.getResStockIds());
            if (deviceStockPOs == null || deviceStockPOs.size() < modifyResStatusReqBO.getResStockIds().size()) {
                return new RspBooleanBO(Boolean.valueOf(false), "\u6709\u4e0d\u5b58\u5728\u7684\u8d44\u6e90\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u66f4\u65b0");
            }
            if (modifyResStatusReqBO.getResType() == 1) {
                this.deviceStockDao.updateBatchByResStockIds(modifyResStatusReqBO.getResStockIds(), modifyResStatusReqBO.getDeviceStockState());
            } else if (modifyResStatusReqBO.getResType() == 2) {
                this.ipInstanceDao.updateBatchIpInstanceByResStockIds(modifyResStatusReqBO.getResStockIds(), modifyResStatusReqBO.getDeviceStockState());
            } else {
                return new RspBooleanBO(Boolean.valueOf(false), "\u8d44\u6e90\u7c7b\u578b\u4e0d\u7b26\u5408,\u8bf7\u786e\u8ba4");
            }
            return new RspBooleanBO(Boolean.valueOf(true), "\u8d44\u6e90\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            throw new BusinessException("10003", "\u8d44\u6e90\u72b6\u6001\u53d8\u66f4\u670d\u52a1\u51fa\u9519");
        }
    }
}

