/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.resource.busi.IpAutoAssignService;
import com.apstar.resource.busi.bo.IpAutoAssignReqBO;
import com.apstar.resource.busi.bo.IpAutoAssignRspBO;
import com.apstar.resource.dao.IpInstanceDao;
import com.apstar.resource.dao.IpSegmentDao;
import com.apstar.resource.dao.SatelliteIpDao;
import com.apstar.resource.dao.SubnetMsaskDao;
import com.apstar.resource.dao.VlanDao;
import com.apstar.resource.po.IpInstancePO;
import com.apstar.resource.po.IpSegmentPO;
import com.apstar.resource.po.SatelliteIpPO;
import com.apstar.resource.po.SubnetMsaskPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ipAutoAssignService")
public class IpAutoAssignServiceImpl
implements IpAutoAssignService {
    private static final Logger logger = LoggerFactory.getLogger(IpAutoAssignServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private IpSegmentDao ipSegmentDao;
    @Autowired
    private IpInstanceDao ipInstanceDao;
    @Autowired
    private VlanDao vlanDao;
    @Autowired
    private SubnetMsaskDao subnetMsaskDao;
    @Autowired
    private SatelliteIpDao satelliteIpDao;

    public IpAutoAssignRspBO ipAutoAssign(IpAutoAssignReqBO ipAutoAssignReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2ipAutoAssignReqBO\uff1a" + ipAutoAssignReqBO.toString());
        }
        this.checkParameter(ipAutoAssignReqBO);
        IpAutoAssignRspBO ipAutoAssignRspBO = new IpAutoAssignRspBO();
        try {
            List<IpSegmentPO> ipSegmentList;
            if (ipAutoAssignReqBO.getResIpType() == 0) {
                ipSegmentList = this.selectIpSegment(ipAutoAssignReqBO);
                Boolean flag = true;
                for (IpSegmentPO ipSegmentPO : ipSegmentList) {
                    List<IpInstancePO> ipInstanceList = this.ipInstanceDao.selectByvlanId(ipSegmentPO);
                    int a = 0;
                    if (ipInstanceList != null && ipInstanceList.size() > 0) {
                        a = Integer.valueOf(this.subIpLast(ipInstanceList.get(0).getResEndIp()));
                    }
                    if (a + ipAutoAssignReqBO.getIpNum() < Integer.valueOf(this.subIpLast(ipSegmentPO.getResEndIp()))) {
                        ipAutoAssignRspBO.setIpId(ipSegmentPO.getResIpId());
                        ipAutoAssignRspBO.setIpNum(ipSegmentPO.getResIpNum());
                        SubnetMsaskPO subnetMsaskPO = this.subnetMsaskDao.selectByIpNum(ipAutoAssignReqBO.getIpNum());
                        if (subnetMsaskPO != null) {
                            ipAutoAssignRspBO.setSubnetMask(subnetMsaskPO.getSubnetMask());
                            ipAutoAssignRspBO.setSubnetMaskId(subnetMsaskPO.getSubnetMaskId());
                        }
                        String ipThird = this.subIpStartThird(ipSegmentPO.getResStartIp());
                        ipAutoAssignRspBO.setResStartIp(String.valueOf(ipThird) + (a + 1));
                        ipAutoAssignRspBO.setResEndIp(String.valueOf(ipThird) + (a + ipAutoAssignReqBO.getIpNum()));
                        ipAutoAssignRspBO.setStaticStartIp(String.valueOf(ipThird) + (a + 1));
                        ipAutoAssignRspBO.setStaticEndIp(String.valueOf(ipThird) + (a + ipAutoAssignReqBO.getStaticIpNum()));
                        ipAutoAssignRspBO.setDynamicStartIp(String.valueOf(ipThird) + (a + ipAutoAssignReqBO.getStaticIpNum() + 1));
                        ipAutoAssignRspBO.setDynamicEndIp(String.valueOf(ipThird) + (a + ipAutoAssignReqBO.getIpNum()));
                        flag = false;
                        break;
                    }
                    this.ipSegmentDao.updateIpStatusByPrimaryKey(ipSegmentPO.getResIpId());
                }
                if (flag.booleanValue()) {
                    throw new BusinessException("10003", "\u8be5VLAN\u7684IP\u8d44\u6e90\u5df2\u4f7f\u7528\u5b8c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6VLAN");
                }
            }
            if (1 == ipAutoAssignReqBO.getResIpType()) {
                ipSegmentList = this.selectIpSegment(ipAutoAssignReqBO);
                int i = ipAutoAssignReqBO.getIpNum() / 8;
                if (ipSegmentList.size() - 1 < i) {
                    throw new BusinessException("10003", "\u8d44\u6e90\u4e0d\u591f\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                ipAutoAssignRspBO.setResStartIp(ipSegmentList.get(0).getResStartIp());
                ipAutoAssignRspBO.setResEndIp(ipSegmentList.get(i).getResEndIp());
                SubnetMsaskPO subnetMsaskPO = this.subnetMsaskDao.selectByIpNum(ipAutoAssignReqBO.getIpNum());
                if (subnetMsaskPO != null) {
                    ipAutoAssignRspBO.setSubnetMask(subnetMsaskPO.getSubnetMask());
                    ipAutoAssignRspBO.setSubnetMaskId(subnetMsaskPO.getSubnetMaskId());
                }
            }
            if (2 == ipAutoAssignReqBO.getResIpType()) {
                List<SatelliteIpPO> satelliteList = this.satelliteIpDao.selectByStatus(0);
                if (satelliteList == null || satelliteList.size() == 0) {
                    throw new BusinessException("10003", "\u8be5\u536b\u661f\u7684IP\u8d44\u6e90\u5df2\u4f7f\u7528\u5b8c");
                }
                List<IpInstancePO> ipInstanceList = this.ipInstanceDao.selectByIpType(ipAutoAssignReqBO.getResIpType());
                int a = 0;
                int b = 0;
                if (ipInstanceList != null && ipInstanceList.size() > 0) {
                    a = Integer.valueOf(this.subThird(ipInstanceList.get(0).getResEndIp()));
                    b = Integer.valueOf(this.subIpLast(ipInstanceList.get(0).getResEndIp()));
                }
                Boolean flag = true;
                int count = 0;
                int i = a;
                while (i <= 255) {
                    a = i;
                    int j = b;
                    while (j < 255) {
                        b = j == 254 ? 0 : j;
                        if (++count == ipAutoAssignReqBO.getIpNum() + 1) {
                            flag = false;
                            break;
                        }
                        ++j;
                    }
                    if (count == ipAutoAssignReqBO.getIpNum() + 1) break;
                    ++i;
                }
                if (flag.booleanValue()) {
                    throw new BusinessException("10003", "\u8be5\u536b\u661f\u7684IP\u8d44\u6e90\u5df2\u4f7f\u7528\u5b8c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u536b\u661f\u7684IP\u8d44\u6e90");
                }
                SubnetMsaskPO subnetMsaskPO = this.subnetMsaskDao.selectByIpNum(ipAutoAssignReqBO.getIpNum());
                if (subnetMsaskPO != null) {
                    ipAutoAssignRspBO.setSubnetMask(subnetMsaskPO.getSubnetMask());
                    ipAutoAssignRspBO.setSubnetMaskId(subnetMsaskPO.getSubnetMaskId());
                }
                if (ipInstanceList == null || ipInstanceList.size() == 0) {
                    ipAutoAssignRspBO.setResStartIp(String.valueOf(this.subSecond(satelliteList.get(0).getSatelliteStartIp())) + 0 + "." + 0);
                    ipAutoAssignRspBO.setResEndIp(String.valueOf(this.subSecond(satelliteList.get(0).getSatelliteStartIp())) + a + "." + b);
                    return ipAutoAssignRspBO;
                }
                if (Integer.valueOf(this.subIpLast(ipInstanceList.get(0).getResEndIp())) + 1 < 255) {
                    ipAutoAssignRspBO.setResStartIp(String.valueOf(this.subIpStartThird(ipInstanceList.get(0).getResEndIp())) + (Integer.valueOf(this.subIpLast(ipInstanceList.get(0).getResEndIp())) + 1));
                } else {
                    ipAutoAssignRspBO.setResStartIp(String.valueOf(this.subSecond(ipInstanceList.get(0).getResEndIp())) + (Integer.valueOf(this.subThird(ipInstanceList.get(0).getResEndIp())) + 1) + "." + 0);
                }
                ipAutoAssignRspBO.setResEndIp(String.valueOf(this.subSecond(ipInstanceList.get(0).getResEndIp())) + a + "." + b);
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException("10003", e.getMessage());
            }
            throw new BusinessException("10003", "IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u51fa\u9519");
        }
        return ipAutoAssignRspBO;
    }

    private String subIpStartThird(String ip) {
        if (ip == null) {
            throw new BusinessException("10003", "IP\u622a\u53d6\u524d\u4e09\u4f4d\u5931\u8d25");
        }
        return ip.substring(0, ip.lastIndexOf(".") + 1);
    }

    private String subIpLast(String str) {
        if (str == null) {
            throw new BusinessException("10003", "IP\u622a\u53d6\u6700\u540e\u4e00\u4f4d\u5931\u8d25");
        }
        return str.substring(str.lastIndexOf(".") + 1);
    }

    private String subThird(String str) {
        if (str == null) {
            throw new BusinessException("10003", "IP\u622a\u53d6\u7b2c\u4e09\u4f4d\u5931\u8d25");
        }
        return str.substring(str.indexOf(".", str.indexOf(".") + 1) + 1, str.lastIndexOf("."));
    }

    private String subSecond(String str) {
        if (str == null) {
            throw new BusinessException("10003", "IP\u622a\u53d6\u7b2c\u4e09\u4f4d\u5931\u8d25");
        }
        return str.substring(0, str.indexOf(".", str.indexOf(".") + 1) + 1);
    }

    private List<IpSegmentPO> selectIpSegment(IpAutoAssignReqBO ipAutoAssignReqBO) {
        IpSegmentPO record = new IpSegmentPO();
        record.setVlanId(ipAutoAssignReqBO.getVlanId());
        record.setResIpType(ipAutoAssignReqBO.getResIpType());
        record.setResIpStatus(0);
        record.setResIpNum(ipAutoAssignReqBO.getIpNum());
        List<IpSegmentPO> ipSegmentList = this.ipSegmentDao.selectByVlanId(record);
        if (ipSegmentList == null || ipSegmentList.size() == 0) {
            throw new BusinessException("10003", "\u8be5VLAN\u7684IP\u8d44\u6e90\u5df2\u4f7f\u7528\u5b8c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6VLAN");
        }
        return ipSegmentList;
    }

    private void checkParameter(IpAutoAssignReqBO ipAutoAssignReqBO) {
        if (ipAutoAssignReqBO.getResIpType() == null) {
            throw new ParametersException("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2[resIpType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ipAutoAssignReqBO.getResIpType() == 0 && ipAutoAssignReqBO.getVlanId() == null) {
            throw new ParametersException("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2[vlanId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ipAutoAssignReqBO.getResIpType() == 0 && ipAutoAssignReqBO.getStaticIpNum() == null) {
            throw new ParametersException("IP\u8d44\u6e90\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5165\u53c2[staticIpNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((ipAutoAssignReqBO.getResIpType() == 0 || 1 == ipAutoAssignReqBO.getResIpType()) && ipAutoAssignReqBO.getIpNum() == null) {
            ipAutoAssignReqBO.setIpNum(Integer.valueOf(8));
        }
        if (2 == ipAutoAssignReqBO.getResIpType() && ipAutoAssignReqBO.getIpNum() == null) {
            ipAutoAssignReqBO.setIpNum(Integer.valueOf(1));
        }
    }
}

