/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.resource.busi.QryDeviceInstInfoService;
import com.apstar.resource.busi.bo.QryDeviceInstInfoBO;
import com.apstar.resource.busi.bo.QryDeviceInstInfoReqBO;
import com.apstar.resource.busi.bo.QryDeviceInstInfoRspBO;
import com.apstar.resource.busi.bo.QryResParameterBO;
import com.apstar.resource.dao.DeviceStockDao;
import com.apstar.resource.dao.ResParameterDao;
import com.apstar.resource.po.DeviceStockPO;
import com.apstar.resource.po.ResParameterPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qryDeviceInstInfoService")
public class QryDeviceInstInfoServiceImpI
implements QryDeviceInstInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QryDeviceInstInfoServiceImpI.class);
    private static final Boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    DeviceStockDao deviceStockDao;
    @Autowired
    ResParameterDao resParameterDao;

    public QryDeviceInstInfoRspBO qryDeviceInstInfo(QryDeviceInstInfoReqBO qryDeviceInstInfoReqBO) {
        if (isDebugEnabled.booleanValue()) {
            logger.debug("\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u67e5\u8be2\u5165\u53c2{}", (Object)qryDeviceInstInfoReqBO.toString());
        }
        if (qryDeviceInstInfoReqBO.getResStockIds().isEmpty() || qryDeviceInstInfoReqBO.getResStockIds() == null) {
            throw new ParametersException("\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\u3010resStockIds\u3011\u4e3a\u7a7a");
        }
        List<DeviceStockPO> deviceStockPOS = this.deviceStockDao.selectByResStockIds(qryDeviceInstInfoReqBO.getResStockIds());
        QryDeviceInstInfoRspBO qryDeviceInstInfoRspBO = new QryDeviceInstInfoRspBO();
        ArrayList<QryDeviceInstInfoBO> qryDeviceInstInfoBOS = new ArrayList<QryDeviceInstInfoBO>();
        try {
            for (DeviceStockPO deviceStockPO : deviceStockPOS) {
                QryDeviceInstInfoBO qryDeviceInstInfoBO = new QryDeviceInstInfoBO();
                qryDeviceInstInfoBO.setResStockId(deviceStockPO.getResStockId());
                qryDeviceInstInfoBO.setDeviceSeq(deviceStockPO.getDeviceSeq());
                qryDeviceInstInfoBO.setDeviceCode(deviceStockPO.getDeviceDesc());
                if (deviceStockPO.getDeviceStockState() != null) {
                    qryDeviceInstInfoBO.setDeviceStockState(deviceStockPO.getDeviceStockState().toString());
                }
                if (deviceStockPO.getDeviceType() != null) {
                    qryDeviceInstInfoBO.setDeviceType(deviceStockPO.getDeviceType().toString());
                }
                qryDeviceInstInfoBO.setDeviceModel(deviceStockPO.getDeviceModel());
                qryDeviceInstInfoBO.setDeviceName(deviceStockPO.getDeviceName());
                qryDeviceInstInfoBO.setDeviceDesc(deviceStockPO.getDeviceDesc());
                if (deviceStockPO.getIsPackDevice() != null) {
                    qryDeviceInstInfoBO.setIsPackDevice(deviceStockPO.getIsPackDevice().toString());
                }
                List<ResParameterPO> resParameterPOS = this.resParameterDao.selectByResStockId(qryDeviceInstInfoBO.getResStockId());
                ArrayList<QryResParameterBO> qryResParameterBOS = new ArrayList<QryResParameterBO>();
                if (resParameterPOS != null) {
                    for (ResParameterPO resParameterPO : resParameterPOS) {
                        QryResParameterBO qryResParameterBO = new QryResParameterBO();
                        qryResParameterBO.setResParameterName(resParameterPO.getResParameterName());
                        qryResParameterBO.setResParameterValue(resParameterPO.getResParameterValue());
                        qryResParameterBO.setResParameterDesc(resParameterPO.getResParameterDesc());
                        qryResParameterBOS.add(qryResParameterBO);
                    }
                }
                qryDeviceInstInfoBO.setResParameters(qryResParameterBOS);
                qryDeviceInstInfoBOS.add(qryDeviceInstInfoBO);
            }
            qryDeviceInstInfoRspBO.setDeviceInstInfos(qryDeviceInstInfoBOS);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("10003", "\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5931\u8d25");
        }
        return qryDeviceInstInfoRspBO;
    }
}

