/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.resource.busi.QryPkgDeviceResService;
import com.apstar.resource.busi.bo.QryDeviceResBO;
import com.apstar.resource.busi.bo.QryPkgDeviceResBO;
import com.apstar.resource.busi.bo.QryPkgDeviceResReqBO;
import com.apstar.resource.busi.bo.QryPkgDeviceResRspBO;
import com.apstar.resource.busi.impl.QryVlanListServiceImpl;
import com.apstar.resource.dao.DevicePackageDao;
import com.apstar.resource.dao.ResMessDao;
import com.apstar.resource.po.DevicePackagePO;
import com.apstar.resource.po.ResMessPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="qryPkgDeviceResService")
public class QryPkgDeviceResServiceImpl
implements QryPkgDeviceResService {
    private static final Logger logger = LoggerFactory.getLogger(QryVlanListServiceImpl.class);
    private static final Boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private DevicePackageDao devicePackageDao;
    @Autowired
    private ResMessDao resMessDao;

    public QryPkgDeviceResRspBO qryPkgDeviceResByPkgId(QryPkgDeviceResReqBO qryPkgDeviceResReqBO) {
        if (isDebugEnabled.booleanValue()) {
            logger.debug("\u6839\u636e\u8bbe\u5907\u5305\u67e5\u8be2\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u670d\u52a1\u5165\u53c2{}" + qryPkgDeviceResReqBO.toString());
        }
        if (StringUtils.isEmpty((Object)qryPkgDeviceResReqBO.getDevicePackageIds()) || qryPkgDeviceResReqBO.getDevicePackageIds().size() == 0) {
            throw new ParametersException("\u6839\u636e\u8bbe\u5907\u5305\u67e5\u8be2\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u670d\u52a1\u5165\u53c2[devicePackageIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            QryPkgDeviceResRspBO qryPkgDeviceResRspBO = new QryPkgDeviceResRspBO();
            List<DevicePackagePO> list = this.devicePackageDao.selectDevPack(qryPkgDeviceResReqBO.getDevicePackageIds());
            ArrayList<QryPkgDeviceResBO> ipInstanceInfoBOs = new ArrayList<QryPkgDeviceResBO>();
            for (DevicePackagePO devicePO : list) {
                QryPkgDeviceResBO qryPkgBO = new QryPkgDeviceResBO();
                qryPkgBO.setDevicePackageId(devicePO.getDevicePackageId());
                qryPkgBO.setDevicePkgChinName(devicePO.getDevicePkgChinName());
                qryPkgBO.setDevicePkgEngName(devicePO.getDevicePkgEngName());
                ArrayList<QryDeviceResBO> list2 = new ArrayList<QryDeviceResBO>();
                ArrayList<String> stringList = new ArrayList<String>();
                String[] pkgRes = devicePO.getDevicePkgRes().split(",");
                int i = 0;
                while (i < pkgRes.length) {
                    stringList.add(pkgRes[i]);
                    ++i;
                }
                List<ResMessPO> resMessList = this.resMessDao.selectRes(stringList);
                for (ResMessPO resMessPO : resMessList) {
                    QryDeviceResBO qryDeviceResBO = new QryDeviceResBO();
                    qryDeviceResBO.setResCode(resMessPO.getResCode());
                    qryDeviceResBO.setResName(resMessPO.getResName());
                    qryDeviceResBO.setResType(resMessPO.getResType());
                    qryDeviceResBO.setResDesc(resMessPO.getResDesc());
                    qryDeviceResBO.setResPrice(resMessPO.getResPrice());
                    qryDeviceResBO.setResMode(resMessPO.getResMode());
                    qryDeviceResBO.setFactory(resMessPO.getFactory());
                    list2.add(qryDeviceResBO);
                }
                qryPkgBO.setDeviceRes(list2);
                ipInstanceInfoBOs.add(qryPkgBO);
            }
            qryPkgDeviceResRspBO.setPkgDeviceRes(ipInstanceInfoBOs);
            return qryPkgDeviceResRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8bbe\u5907\u5305\u67e5\u8be2\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("10003", "\u6839\u636e\u8bbe\u5907\u5305\u67e5\u8be2\u8bbe\u5907\u8d44\u6e90\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }
}

