/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.resource.busi.InstanceDeviceService;
import com.apstar.resource.busi.bo.InstanceDeviceBO;
import com.apstar.resource.busi.bo.InstanceDeviceReqBO;
import com.apstar.resource.busi.bo.InstanceDeviceRspBO;
import com.apstar.resource.dao.DeviceStockDao;
import com.apstar.resource.po.DeviceStockPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="instanceDeviceService")
public class InstanceDeviceServiceImpl
implements InstanceDeviceService {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDeviceServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private DeviceStockDao deviceStockDao;

    public InstanceDeviceRspBO instanceDevice(InstanceDeviceReqBO instanceDeviceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b9e\u4f8b\u5316\u8bbe\u5907\u670d\u52a1\u5165\u53c2modifyResStatusReqBO\uff1a" + instanceDeviceReqBO.toString());
        }
        if (StringUtils.isEmpty((Object)instanceDeviceReqBO.getInstanceDevices()) || instanceDeviceReqBO.getInstanceDevices().size() == 0) {
            throw new ParametersException("\u5b9e\u4f8b\u5316\u8bbe\u5907\u670d\u52a1\u5165\u53c2[instanceDevices]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InstanceDeviceRspBO instanceDeviceRspBO = new InstanceDeviceRspBO();
        ArrayList<Long> resStockIds = new ArrayList<Long>();
        for (InstanceDeviceBO instanceDeviceBO : instanceDeviceReqBO.getInstanceDevices()) {
            if (StringUtils.isEmpty((Object)instanceDeviceBO.getResCode())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316\u8bbe\u5907\u670d\u52a1\u5165\u53c2[resCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)instanceDeviceBO.getResNum())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316\u8bbe\u5907\u670d\u52a1\u5165\u53c2[resNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<DeviceStockPO> deviceStockPOList = this.deviceStockDao.selectByDeviceCode(instanceDeviceBO.getResCode());
            if (deviceStockPOList == null || deviceStockPOList.size() == 0) {
                throw new BusinessException("20001", "\u6709\u4e0d\u5b58\u5728\u7684\u8bbe\u5907\u8d44\u6e90\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u67e5\u8be2");
            }
            try {
                for (int i = 0; i < instanceDeviceBO.getResNum(); ++i) {
                    DeviceStockPO deviceStockPO = new DeviceStockPO();
                    deviceStockPO.setResStockId(deviceStockPOList.get(i).getResStockId());
                    deviceStockPO.setDeviceStockState(2);
                    this.deviceStockDao.updateByPrimaryKeySelective(deviceStockPO);
                    resStockIds.add(deviceStockPOList.get(i).getResStockId());
                }
            }
            catch (Exception e) {
                logger.error("\u5b9e\u4f8b\u5316\u8bbe\u5907\u670d\u52a1\u51fa\u9519", (Throwable)e);
                throw new BusinessException("10003", "\u5b9e\u4f8b\u5316\u8bbe\u5907\u670d\u52a1\u51fa\u9519");
            }
        }
        instanceDeviceRspBO.setResStockIds(resStockIds);
        return instanceDeviceRspBO;
    }
}

