/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.credential.SimpleTokenCache;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class BearerTokenAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";
    private final TokenCredential credential;
    private final String[] scopes;
    private final SimpleTokenCache cache;

    public BearerTokenAuthenticationPolicy(TokenCredential credential, String ... scopes) {
        Objects.requireNonNull(credential);
        Objects.requireNonNull(scopes);
        assert (scopes.length > 0);
        this.credential = credential;
        this.scopes = scopes;
        this.cache = new SimpleTokenCache(() -> credential.getToken(new TokenRequestContext().addScopes(scopes)));
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        return this.cache.getToken().flatMap(token -> {
            context.getHttpRequest().getHeaders().put(AUTHORIZATION_HEADER, "Bearer " + token.getToken());
            return next.process();
        });
    }
}

