/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class EncryptionProtectorProperties {
    @JsonProperty(value="subregion", access=JsonProperty.Access.WRITE_ONLY)
    private String subregion;
    @JsonProperty(value="serverKeyName")
    private String serverKeyName;
    @JsonProperty(value="serverKeyType", required=true)
    private ServerKeyType serverKeyType;
    @JsonProperty(value="uri", access=JsonProperty.Access.WRITE_ONLY)
    private String uri;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionProtectorProperties.class);

    public String subregion() {
        return this.subregion;
    }

    public String serverKeyName() {
        return this.serverKeyName;
    }

    public EncryptionProtectorProperties withServerKeyName(String serverKeyName) {
        this.serverKeyName = serverKeyName;
        return this;
    }

    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    public EncryptionProtectorProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public void validate() {
        if (this.serverKeyType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property serverKeyType in model EncryptionProtectorProperties"));
        }
    }
}

